var map;
var earthquake_data_all;

function initialize(lat, lon) {
	var myLatLng = new google.maps.LatLng(lat, lon);
	var mapOptions = {
		center: myLatLng,
		zoom: 6,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	map = new google.maps.Map(document.getElementById("map_canvas"), mapOptions);

	// 地震データの読み込み
	earthquake_data_all = new Array();
	// Work loop
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		// File loop
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			// Subject loop
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
            var earthquake_data = {}
				earthquake_data["id"] = subjValue;
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						if(propValue == "http://linkdata.org/property/rdf1s3493i#" + encodeURIComponent("発生日")){
							earthquake_data["date"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s3493i#" + encodeURIComponent("発生時刻")){
							earthquake_data["time"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#lat"){
							earthquake_data["lat"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#long"){
							earthquake_data["lng"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s3493i#" + encodeURIComponent("深さ")){
							earthquake_data["depth"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s3493i#" + encodeURIComponent("マグニチュード")){
							earthquake_data["magnitude"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s3493i#" + encodeURIComponent("最大震度")){
						    earthquake_data["scale"] = objValue;
						}
					});
				});
				earthquake_data_all.push(earthquake_data);
				//link to map display if coordinates exist
			});
		});
	});
	
	// マーカーを作る
	makeMarker();
}

// マーカーを作る
function makeMarker() {
	for (var i = 0; i < earthquake_data_all.length; i ++) {
		makeMarkerSub(earthquake_data_all[i]);
	}
}

function makeMarkerSub(earthquake_data) {
	// 適切なマーカーアイコンを選択
	var image = null;
	if (earthquake_data.scale == '1') {
		image = "http://app.linkdata.org/asset/a502a960.png";
	} else if (earthquake_data.scale == '2') {
		image = "http://app.linkdata.org/asset/cc8f5396.png";
	} else if (earthquake_data.scale == '3') {
		image = "http://app.linkdata.org/asset/a3c3359b.png";
	} else if (earthquake_data.scale == '4') {
		image = "http://app.linkdata.org/asset/99eea85a.png";
	} else if (earthquake_data.scale == 'A') {
		image = "http://app.linkdata.org/asset/922a64ab.png";
	} else if (earthquake_data.scale == 'B') {
		image = "http://app.linkdata.org/asset/64e1f88d.png";
	} else if (earthquake_data.scale == 'D') {
		image = "http://app.linkdata.org/asset/a1f204c5.png";
	} else if (earthquake_data.scale == 'C') {
		image = "http://app.linkdata.org/asset/b91c895f.png";
	} else if (earthquake_data.scale == '7') {
		image = "http://app.linkdata.org/asset/588aab26.png";
	}
	var marker = new google.maps.Marker({
		position: new google.maps.LatLng(earthquake_data.lat, earthquake_data.lng),
		map: map,
		icon: image,
		title: earthquake_data.id
		});
	var content = '発生日時：' + earthquake_data.date + " " + earthquake_data.time + '<br />';
	content += '最大震度：' + earthquake_data.scale + '<br />';
	content += 'マグニチュード：' + earthquake_data.magnitude + '<br />';
	content += '深さ(km)：' + earthquake_data.depth + '<br />';
	google.maps.event.addListener(marker, 'click', function() {
		var infowindow = new google.maps.InfoWindow({
			content: content
		});
		infowindow.open(map, marker);
	});
	return marker;
}

window.onload = function() {
    $(function(){
    	initialize(35.690551, 139.69257);        
    });	
};
