var PG = PG || {};

// プロパティの設定
PG.property = {
	image : "http://schema.org/image",
	label : "http://purl.org/dc/elements/1.1/title",
	detail : "http://purl.org/dc/elements/1.1/description",
	address : "http://uidcenter.org/vocab/ucr/ug#address",
	long : "http://www.w3.org/2003/01/geo/wgs84_pos#long",
	lat : "http://www.w3.org/2003/01/geo/wgs84_pos#lat"
}
	
// デフォルト言語
PG.language = "ja";
	
$(function() {
	// オーバーレイを追加
	$('body').append('<div class="modal-overlay"></div>');
	// オーバーレイをフェードイン
	$('.modal-overlay').fadeIn('slow');

	// モーダルコンテンツを追加
	var modal = '<div class="modal-content"><div id="comment"><p>Click Here!</p><ul><li id="ja">日本語</li><li id="en">English</li><li id="zhCHS">简体中文</li><li id="zhCHT">繁體中文</li><li id="ko">한국어</li></ul></div><img id="cat" src="http://app.linkdata.org/asset/79eaad8f.png" /></div>';
	$('body').append(modal);
	// モーダルコンテンツの表示位置を設定
	modalResize();
	
	// 猫出現
	setTimeout(function(){
		$('.modal-content').fadeIn('slow');
	}, 500);
	
	// コメントボックスの操作
	$("#comment, #cat").on('click', function() {
		$("#comment li").toggle(500);
	});

	// .modal-overlayをクリック
	$('#comment li').off().click(function(){
		PG.language = $(this).attr("id");
		// モーダルコンテンツとオーバーレイをフェードアウト
		$('.modal-content').fadeOut('slow');
		$('.modal-overlay').fadeOut('slow',function(){
			// オーバーレイを削除
			$('.modal-overlay').remove();
		});
	});

	// リサイズしたら表示位置を再取得
	$(window).on('resize', function(){
		modalResize();
	});

	// モーダルコンテンツの表示位置を設定する関数
	function modalResize(){
		// ウィンドウの横幅、高さを取得
		var w = $(window).width();
		var h = $(window).height();
		console.log("w:" + w + "h:" + h);

		// モーダルコンテンツの表示位置を取得
		var x = (w / 2) -120;
		var y = (h / 2) -200;
		console.log("x:" + x + "y:" + y);

		// モーダルコンテンツの表示位置を設定
		$('.modal-content').css({'left': x + 'px','top': y + 'px'});
	}
	
	// スマホでもボタンがへこむ効果を付ける
	var $elm = $('#push');
	$elm.bind('touchstart', function() {
    	$(this).addClass('tch-active');
	});
	$elm.bind('touchend', function() {
    	$(this).removeClass('tch-active');
	});
});

$("#push").click(function () {
	var list = "";
	$("#result").empty();
	$("#omikuji, #showAll").remove();
	// 指定されたworkを全件取得
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		// workに含まれるfileを全件取得
		var propUri = stringToUri(PG.property, workValue);
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			var filename = fileValue.split("_");
			if (filename[filename.length-1]==PG.language) {
				var index = 0;
				var random = 0;
				var subList = [];
				// subjectを全件取得
				$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
					var image = "";
					var label = "";
					var detail = "";
					var address = "";
					var longitude = "";
					var latitude = "";
					var str = "";
					$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
						var prop = tripleValue.property;
						var obj = tripleValue.object;
						if ( prop == propUri.image)  image = obj;
						else if ( prop == propUri.label ) label = obj ;
						else if ( prop == propUri.detail ) detail = obj ;
						else if ( prop == propUri.address && obj.length != 0) address = "<p class=\"address\"><img src=\"http://app.linkdata.org/asset/831091f7.png\" />" + obj + "</p>" ;
						else if ( prop == propUri.long ) longitude = obj;
						else if ( prop == propUri.lat ) latitude = obj;
					});
					if (image == "") return;
					subList.push(subjValue);
					str += "<li class=\"flipImage\"><div class=\"front\"><a href='#'><img src=\"" + image + "\" alt=\"image\" /></a></div><div class=\"back\"><p class=\"label\">" + label + "<p class=\"detail\">" + detail  + "</p>" + address + "<span class=\"button\">" + addLinkToMap(latitude, longitude) + "</span></div></li>"
					list += str;
					index += 1;
				});
				var image = "";
				var label = "";
				var detail = "";
				var address = "";
				var longitude = "";
				var latitude = "";
				var str = "";
				random = Math.floor( Math.random() * index);
				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subList[random]), function( tripKey, tripValue ) {
					var prop = tripValue.property;
					var obj = tripValue.object;
					if ( prop == propUri.image)  image = obj;
					else if ( prop == propUri.label ) label = obj ;
					else if ( prop == propUri.detail ) detail = obj ;
					else if ( prop == propUri.address && obj.length != 0) address = "<p class=\"address\"><img src=\"http://app.linkdata.org/asset/831091f7.png\" />" + obj + "</p>" ;
					else if ( prop == propUri.long ) longitude = obj;
					else if ( prop == propUri.lat ) latitude = obj;
				});
				$("#omikujibox").append('<div id="omikuji"><div id="omikujiInner"><p class=\"label\">Your Lucky Place：</p><h4>' + label + '</h4><img src="' + image + '" alt="image" /><p class="detail">' + detail  + '</p>' + address + '<span class="button" id="showMap">' + addLinkToMap(latitude, longitude) + '</span></div></div>');
			}
		});
	});
	$("#result").append( list );
	
	// 画像を正方形にトリミング
	$(".front").imgLiquid();
	
	// 画像が読み込めなかった時の処理
	$("img").error(function(){
		$(this).before("No Image");
	});
	
	$( 'a' )
	  .bind( 'touchstart', function(){
 	   $( this ).addClass( 'hover' );
	}).bind( 'touchend', function(){
	    $( this ).removeClass( 'hover' );
	});
	
	$("#omikuji").fadeIn(500, function(){
		// 画像を折りたたむエフェクト
		var $folded = $('#omikuji').oriDomi({
			hPanels: 8,
			speed: 0,
			shadingIntesity: .6
		});
		$folded.oriDomi('reveal', 1000, 'top');
		setTimeout(function(){
			$folded.oriDomi('reveal', 0, 'top')
				.oriDomi('setSpeed', 2000);
		}, 2000);
	});
	
	setTimeout(function(){
		$('html,body').animate({ scrollTop: 400 }, 2000);
	}, 1000);
	
	$("#omikujibox").after('<div id="showAll"><p>Show All</p><p class="off">Hide</p></div>');

	$("#showAll").on('click', function() {
		$("#showAll p").toggleClass("off")
		$('.photo-grid').toggle(500);
	});

});

// Google Mapのルート検索へのリンクを追加
function addLinkToMap( latitude, longitude )
{
	var str = "";
	if (latitude.length != 0 && longitude.length != 0) {
		str = "<a target=\"_blank\" class=\"object\" href=\"http://maps.google.co.jp/maps?daddr=" + latitude + "," + longitude + "\">Show Map</a>"
	}
	return str;
}

function stringToUri (p, workId) {
	$.each (p, function(propKey, propVal){
		if(propVal.indexOf("http") != 0){
			p[propKey] = "http://linkdata.org/property/" + workId + "#" + encodeURIComponent(propVal);
		}
	})
	return p;
}
