/**
 * patapata.js
 * @version 0.3
 * @author Yu Yagi
 * @license Public Domain
 */

function Patapata(canvas, items, speed) {
    Patapata.version = '0.3';
    if (!Patapata.instances) {
        Patapata.instances = [];
    }

    Patapata.prototype.drawText = function (c, t) {
        var w, h, tw, m;

        if (typeof (t) === 'string') {
            t = { text: t };
        }

        w = c.canvas.width;
        h = c.canvas.height;

        c.fillStyle = t.bg ? t.bg : 'black';
        c.fillRect(0, 0, w, h);

        if (t.border) {
            c.lineWidth = Math.floor(h * 0.02);
            c.strokeStyle = t.border;
            c.strokeRect(0, 0, w, h);
        }

        c.canvas.title = t.text;
        c.font = Math.floor(h * 0.8) + "px " + this.font;
        c.textAlign = 'center';
        c.textBaseline = 'top';
        c.fillStyle = t.fg ? t.fg : 'white';

        tw = c.measureText(t.text).width;
        m = 1;
        if (tw > w - c.lineWidth * 2) {
            m = (w - c.lineWidth * 2) / tw;
            c.setTransform(m, 0, 0, 1, 0, 0);
        }

        if (t.sub) {
            c.transform(0.75, 0, 0, 0.75, 0, 0);
            m *= 0.75;
        }

        c.fillText(t.text, w / 2 / m, 0);
        c.setTransform(1, 0, 0, 1, 0, 0);

        if (t.sub) {
            c.font = Math.floor(h * 0.2) + "px " + this.font;
            c.fillText(t.sub, w / 2, h * 0.7);
        }
    };

    Patapata.prototype.drawFlip = function (pt, nt, mg) {
        var pk, nk, prev, next, mc, w, h;

        pk = JSON.stringify(pt);
        nk = JSON.stringify(nt);

        if (!this.flips[pk]) {
            this.flips[pk] = document.createElement('canvas');
            this.flips[pk].width = this.canvas.width;
            this.flips[pk].height = this.canvas.height;
            this.flips[pk].style.display = 'none';
            this.drawText(this.flips[pk].getContext('2d'), pt);
        }

        if (!this.flips[nk]) {
            this.flips[nk] = document.createElement('canvas');
            this.flips[nk].width = this.canvas.width;
            this.flips[nk].height = this.canvas.height;
            this.flips[nk].style.display = 'none';
            this.drawText(this.flips[nk].getContext('2d'), nt);
        }

        prev = this.flips[pk];
        next = this.flips[nk];

        if (!this.canvas.getContext) {
            return false;
        }

        mc = this.canvas.getContext('2d');
        w = this.canvas.width;
        h = this.canvas.height;

        mc.fillStyle = 'white';
        mc.fillRect(0, 0, w, h);
        mc.drawImage(next, 0, 0, w, h / 2, 0, 0, w, h / 2);
        mc.drawImage(prev, 0, h / 2, w, h / 2, 0, h / 2, w, h / 2);

        if (mg > 0) {
            mc.fillRect(0, h / 2 * (1 - mg), w, h / 2 * mg);
            mc.drawImage(prev, 0, 0, w, h / 2,
                    0, h / 2 * (1 - mg), w, h / 2 * mg);
        } else if (mg < 0) {
            mc.fillRect(0, h / 2, w, h / 2 * -mg);
            mc.drawImage(next, 0, h / 2, w, h / 2,
                    0, h / 2, w, h / 2 * -mg);
        }

        mc.fillStyle = 'white';
        mc.fillRect(0, h / 2 - 1, w, 2);
    };

    Patapata.prototype.drawPtpt = function () {
        var i, j, rad;

        while (this.deg < 0) {
            this.deg += 180;
        }

        if (this.deg > this.items.length * 180) {
            this.deg %= this.items.length * 180;
        }

        i = Math.floor(this.deg / 180);
        j = i === this.items.length - 1 ? 0 : i + 1;
        rad = Math.cos((this.deg % 180) * Math.PI / 180);
        this.drawFlip(this.items[i], this.items[j], rad);

        if (i === this.stopValue && i !== this.stopState) {
            if (this.stopLoop <= 0) {
                return;
            }

            this.stopLoop -= 1;
        }

        this.deg += (this.deg % 180) * this.speed + 1;
        this.stopState = i;
        setTimeout('Patapata.instances[' + this.id + '].drawPtpt()', 5);
    };

    Patapata.prototype.set = function (i, l) {
        this.stopValue = i;
        this.stopLoop = l ? l : 0;
    };

    this.id = Patapata.instances.push(this) - 1;
    this.canvas = canvas;
    this.items = items;
    this.deg = 0;
    this.speed = speed ? speed : 0.1;
    this.flips = {};
    this.font = canvas.style.fontFamily !== ''
        ? canvas.style.fontFamily : 'sans-serif';

    this.stopState = -1;
    this.stopValue = -1;
    this.stopLoop = 1;

    this.drawPtpt();
}

/* vim: set ts=4 sw=4 expandtab: */
