var PG = PG || {};

// ※プロパティの設定
PG.property = {
	image : "http://schema.org/image",
	label : "札",
	detail : "http://purl.org/dc/elements/1.1/description",
	address : "札",
	long : "http://www.w3.org/2003/01/geo/wgs84_pos#long",
	lat : "http://www.w3.org/2003/01/geo/wgs84_pos#lat"
}

$("#push").click(function () {
	var list = "";
	var index = 0;
	var random = 0;
	$("#result").empty();
	$("#omikuji, #showAll").remove();
	// 指定されたworkを全件取得
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		// workに含まれるfileを全件取得
		var propUri = stringToUri(PG.property, workValue);
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			random = Math.floor( Math.random() * LinkData.getSubjects(workValue, fileValue).length);
			// subjectを全件取得
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var image = "";
				var label = "";
				var detail = "";
				var address = "";
				var longitude = "";
				var latitude = "";
				var str = "";
				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
					var prop = tripleValue.property;
					var obj = tripleValue.object;
					if ( prop == propUri.image )  image = obj;
					else if ( prop == propUri.label ) label = obj ;
					else if ( prop == propUri.detail ) detail = obj ;
					else if ( prop == propUri.address && obj.length != 0) address = "<p class=\"address\"><img src=\"http://app.linkdata.org/asset/831091f7.png\" />" + obj + "</p>" ;
					else if ( prop == propUri.long ) longitude = obj;
					else if ( prop == propUri.lat ) latitude = obj;
				});
				str += "<li class=\"flipImage\"><div class=\"front\"><a href='#'><img src=\"" + image + "\" alt=\"image\" /></a></div><div class=\"back\"><p class=\"label\">" + label + "<p class=\"detail\">" + detail  + "</p>" + address + "<span class=\"button\">" + addLinkToMap(latitude, longitude) + "</span></div></li>"
				list += str;
				index += 1;
				if (index === random) {
					$("#omikujibox").append('<div id="omikuji"><div id="omikujiInner"><p class=\"label\">ラッキー諺(ｗ)は：</p><h4>' + label + '</h4><img src="' + image + '" alt="image" /><p class="detail">' + detail  + '</p>' + address + '<span class="button">' + addLinkToMap(latitude, longitude) + '</span></div></div>');
				}
			});
		});
	});
	$("#result").append( list );
	
	// 画像を正方形にトリミング
	$(".front").imgLiquid();
	
	// 画像が読み込めなかった時の処理
	$("img").error(function(){
		$(this).before("No Image");
	});
	
	$( 'a' )
	  .bind( 'touchstart', function(){
 	   $( this ).addClass( 'hover' );
	}).bind( 'touchend', function(){
	    $( this ).removeClass( 'hover' );
	});
	
	$("#omikuji").fadeIn(500, function(){
		// 画像を折りたたむエフェクト
		var $folded = $('#omikuji').oriDomi({
			hPanels: 8,
			speed: 0,
			shadingIntesity: .6
		});
		$folded.oriDomi('reveal', 1000, 'top');
		setTimeout(function(){
			$folded.oriDomi('reveal', 0, 'top')
				.oriDomi('setSpeed', 2000);
		}, 2000);
	});
	
	setTimeout(function(){
		$('html,body').animate({ scrollTop: 400 }, 1000);
	}, 1000);
	
	$("#omikujibox").after('<div id="showAll"><p>Show All</p><p class="off">Hide</p></div>');
	$("#showAll").on('click', function() {
		$("#showAll p").toggleClass("off")
//		$("#showAll").text('Hide');
		$('.photo-grid').toggle(500);
	});
});

// Google Mapのルート検索へのリンクを追加
function addLinkToMap( latitude, longitude )
{
	var str = "";
	if (latitude.length != 0 && longitude.length != 0) {
		str = "<a target=\"_blank\" class=\"object\" href=\"http://maps.apple.com/?q=" + latitude + "," + longitude + "\">Show Map</a>"
	}
	return str;
}

function stringToUri (p, workId) {
	$.each (p, function(propKey, propVal){
		if(propVal.indexOf("http") != 0){
			p[propKey] = "http://linkdata.org/property/" + workId + "#" + encodeURIComponent(propVal);
		}
	})
	return p;
}


