var LV = LV || {};
var dct = "http://purl.org/dc/terms/";
var ic = "http://imi.go.jp/ns/core/rdf#";
var dcat = "http://www.w3.org/ns/dcat#";

// ※表示タイトル
LV.title = "オープンデータカタログ";

// ※テーブルの項目名とプロパティの対応の設定
LV.property = [
	["ID", "0"],	/* 必須 */
	["タイトル", dct + "title"],
	["作成者", dct + "creator"],
	["市区町村コード", ic + "市区町村コード"],
	["説明", dct + "description"],
	["タグ", dcat + "keyword"],
	["リリース日", dct + "issued"],
	["公開ウェブページ", dct + "landingPage"],
	["ダウンロードURL", dcat + "accessURL"],
	["データ形式", dct + "format"],
	["ファイルサイズ(byte)", dcat + "byteSize"],
	["ライセンス", dct + "license"]
]
	
window.onload = function() {
	$("#result").append("<h1>" + LV.title + "</h1>");
	$("#result").append("<table class='display' id='data_list'></table>" );
	var colList=[];
	$('#data_list').dataTable({
		"aoColumns": setColName(colList),
		"asSorting": [[0,"desc"]],
		"bJQueryUI": true,
		"bAutoWidth": false,
		"bJQueryUI": true,
		
		/* 空の値が来たらハイフン表示（alert対策） */
		"columnDefs": [{
   			 "defaultContent": "-",
			"targets": "_all"
		}],
		/* 日本語化 */
		"language": {
  			"emptyTable" : "データが登録されていません。",
  			"info" : "_TOTAL_ 件中 _START_ 件から _END_ 件までを表示",
			"infoEmpty" : "",
			"infoFiltered" : "(_MAX_ 件からの絞り込み表示)",
			"infoPostFix" : "",
			"thousands" : ",",
			"lengthMenu" : "1ページあたりの表示件数: _MENU_",
			"loadingRecords" : "ロード中",
			"processing" : "処理中...",
			"search" : "検索：",
			"zeroRecords" : "該当するデータが見つかりませんでした。",
			"paginate" : {
				"first" : "先頭",
				"previous" : "前へ",
				"next" : "次へ",
				"last" : "末尾"
			}
		}

	});
	
	/* LinkDataからデータを取得 */
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		var propList = stringToUri(LV.property, workValue);
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var dataList = [];
				
				/* ID列のデータ取得 */
				var sharp = decodeURIComponent(subjValue).split("#");
				var slash = sharp[sharp.length-1].split("/");
				var id = slash[slash.length-1];
				dataList[0] = id;
				
				/* その他の列のデータを取得 */
				$.each( LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					$.each (propList, function(i, propUri){
						if (propUri == propValue) {
							var objList = [];
							$.each( LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objkey, objValue) {
								objList.push(objValue);
							});
							dataList[i+1] = addHtml(objList.toString());
						}
					});
				});
				/* テーブルにデータを追加 */
				$('#data_list').dataTable().fnAddData(dataList);
			});
		});
	});
}

/* プロパティがリテラルで指定された場合にURIに変換 */
function stringToUri (p, workId) {
	var arr = [];
	$.each (p, function(){
		if(this[1] != 0) {
			if(this[1].indexOf("http") != 0){
				arr.push("http://linkdata.org/property/" + workId + "#" + encodeURIComponent(this[1]));
			} else {
				arr.push(this[1]);
			}
		}
	})
	return arr;
}

/* カラム名を設定 */
function setColName(arr) {
	$.each(LV.property, function(){
		var col = {};
		col.sTitle = this[0];
		arr.push(col);
	})
	return arr;
}

/* データの値がURLの場合の処理 */
function addHtml(str) {
	if (str.indexOf("http") == 0) {
		if ((str.indexOf(".jpg" )>0 || str.indexOf(".gif" )>0 || str.indexOf(".png" )>0) || (str.indexOf(".JPG" )>0 || str.indexOf(".GIF" )>0 || str.indexOf(".PNG" )>0)) {
		str = '<img src="' + str + '" />';
		} else {
			str = '<a href="' + str + '" target="_blank">' + str + '</a>';
		}
	}
	return str;
}
