if (typeof Application == "undefined" || !Application) {
	var Application = {};
}

Application.genocon = function() {
	this._init.apply(this, arguments);
};

Application.genocon.prototype = {
	
	CHAR_SEQ_EMPTY : "-",
	
	_baseSequence : null,
	_tooltip : null,
	_methodList : null,
	_appBaseLineSequence : null,
	
	_default : {
		baseSequenceContainerId : "baseSequenceContainer",
		fixedSequenceClass : "fixedSequence",
		finishSequence : "finishSequence",
		baseErrorMessageClass : "baseErrorMessage",
		errorMessageEnterSequence : "Please enter a sequence of minimum length {0}",
		errorMessageMaximumSequence : "Please enter a sequence of maximum length {0}",
		useButtonClass : "useButton",
		nextButtonClass : "nextButton",
		finishNowButtonClass : "finishNow",
		nextButtonContainerClass : "nextButtonContainer",
		collapseButton : "collapseButton",
		expandButton : "expandButton",
		removeButton : "removeButton",
		appContainerClass : "applicationContainer",
		appDataContainerClass : "applicationDataContainer",
		actionButtonContainer : "actionButtonContainer",
		actionResultContainer : "actionResultContainer",
		baseSequenceBoxClass : "baseSequenceBox",
		baseSequenceClass : "baseSequence",
		selectDataBaseList : "databaseList",
		selectMethodList : "optionList",
		databaseFilteringProperty : "#motif%20sequence",
		methodUrlProperty : "#application%20URL",
		baseSequenceMinLength : 50,
		baseSequenceMaxLength : 500,
		applicationOptionClass : "applicationOptionRadio"
	},
	
	_tag : {
		databaseTag : "database",
		methodTag : "method"
	},
	
	_tooltipName : {
		atGeneExpress : "atgenexpress",
		diurnal : "diurnal",
		selectDatabase : "selectdatabase",
		selectTool : "selecttool",
		motifExpress : "motifexpress",
		motifCircatian : "motifcircadian",
		motifRank : "motifrank",
		motifQuery : "motifquery",
		defaultSequence : "basesequence",
		fixedSequence : "gacccttcctctatataaggaagttcatttcatttggagaggacctcgac",
		finishNow : "finishnow",
		next : "next",
		start : "start",
	},
	
	_init : function() {
		this._methodList = [];
		this._initToolTip();
		this._initDefaultSequence();
		this._initAppBaseLineSequence();
		this._initLoadScript();
		this._initUseButtonListener();
	},
	
	_initToolTip : function() {
		this._tooltip = new Application.tooltip();
	},
	
	_initDefaultSequence : function() {
		var self = this, sb = [];
		for (var i = 0; i < self._default.baseSequenceMaxLength; i++) {
			sb[sb.length] = self.CHAR_SEQ_EMPTY;
		}
		$baseInput = $("#" + this._default.baseSequenceContainerId + " ." + this._default.baseSequenceClass);
		$baseInput.val(sb.join(""));
		$baseInput.keyup(function() {
			var size = ($baseInput.val().length != 0) ? $baseInput.val().length : 1;
			$baseInput.attr("size", size);
		});
		$("#" + this._default.baseSequenceContainerId + " ." + this._default.baseSequenceBoxClass).scrollLeft(10000);
		var timer = new Application.timer();
		var applyToolTip = function() {
			var dToolTip = self._getToolTip(self._tooltipName.defaultSequence);
			var fToolTip = self._getToolTip(self._tooltipName.fixedSequence);
			if (dToolTip && fToolTip) {
				$("#" + self._default.baseSequenceContainerId + " ." + self._default.baseSequenceClass).attr("title", dToolTip);
				$("#" + self._default.baseSequenceContainerId + " ." + self._default.fixedSequenceClass).attr("title", fToolTip);
			} else {
				timer.call(applyToolTip);
			}
		}
		applyToolTip();
	},
	
	_initAppBaseLineSequence : function() {
		this._appBaseLineSequence = new Application.baseLineSequence();
	},
	
	_initLoadScript : function() {
		var self = this;
		var getFilesByTag = function(result) {
			$.each(result, function(workId, fileArray){
				$.each(fileArray, function(fileKey, fileName) {
					var getProperties = function(propertytList) {
						$.each(propertytList, function(propKey, propVal) {
							if (propVal.indexOf(self._default.methodUrlProperty) > -1) {
								self._loadPluginScriptList(workId, fileName, propVal);
								return false;
							}
						});
					}
					LinkData.getProperties(workId, fileName, getProperties);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, self._tag.methodTag, getFilesByTag);
	},
	
	_initDefaultContainer : function() {
		this._initDatabase();
		this._initMethod();
		this._initActionButton();
		this._initDatabaseListener();
		this._initMethodListener();
	},
	
	_initDatabase : function() {
		var self = this;
		var $select = $("." + self._default.appContainerClass + " ." + self._default.selectDataBaseList);
		$select.attr("title", self._getToolTip(self._tooltipName.selectDatabase));
		$("option", $select).remove();
		$select.append("<option value='-1' selected='selected'>-- Select Database --</option>");
		var getFilesByTag = function(result) {
			$.each(result, function(workId, fileArray){
				$.each(fileArray, function(fileKey, fileName) {
					var dbKey = self._getDatabaseOptionKey(workId, fileName);
					var tooltip = self._tooltip.getByKey(fileName);
					$select.append("<option value='" + dbKey + "' title='" + tooltip + "'>" + fileName + "</option>");
				});
			});
		}
		LinkData.getFilesByTag("", self._tag.databaseTag, getFilesByTag);
	},
	
	_initMethod : function() {
		var self = this;
		var $select = $("." + self._default.appContainerClass + " ." + self._default.selectMethodList);
		$("option", $select).remove();
		$select.append("<option value='-1' selected='selected'>-- Select Tool --</option>");
		$select.attr("title", self._getToolTip(self._tooltipName.selectTool));
		var getFilesByTag = function(result) {
			$.each(result, function(workId, fileArray){
				$.each(fileArray, function(fileKey, fileName) {
					var getSubjects = function(subjectList) {
						$.each(subjectList, function(subKey, subVal) {
							var label = self._getLabel(subVal);
							var tooltip = self._getToolTipByToolName(label);
							tooltip = (tooltip) ? tooltip : "";
							$select.append("<option value='" + label + "' title='" + tooltip + "'>" + label + "</option>");
							self._methodList.push(label);
						});
					}
					LinkData.getSubjects(workId, fileName, getSubjects);
				});
			});
		}
		LinkData.getFilesByTag(null, self._tag.methodTag, getFilesByTag);
	},
	
	_initActionButton : function() {
		var self = this;
		$("." + self._default.actionButtonContainer + " ." + self._default.collapseButton).click(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$(parent).find("." + self._default.appDataContainerClass).hide();
		});
		$("." + self._default.actionButtonContainer + " ." + self._default.expandButton).click(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$(parent).find("." + self._default.appDataContainerClass).show();
		});
		$("." + self._default.actionButtonContainer + " ." + self._default.removeButton).click(function() {
			$(this).closest("." + self._default.appContainerClass).remove();
		});
	},
	
	_initDatabaseListener : function() {
		var self = this;
		var $selectDb = $("." + self._default.appContainerClass + " ." + self._default.selectDataBaseList);
		$selectDb.change(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$(parent).find("." + self._default.applicationOptionClass).hide();
			$(parent).find("." + self._default.selectMethodList + " option").removeAttr("selected");
			$(parent).find("." + self._default.nextButtonContainerClass).hide();
			$container = $(parent).find("." + self._default.actionResultContainer);
			$container.html("");
			var dbKey = $("option:selected", $(this)).val();
			self._changeMethodList(dbKey);
		});
	},
	
	_initMethodListener : function() {
		var self = this;
		var $selectDb = $("." + self._default.appContainerClass + " ." + self._default.selectDataBaseList);
		var $select = $("." + self._default.appContainerClass + " ." + self._default.selectMethodList);
		$select.change(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			var method = $("option:selected", $(this)).text();
			var database = $("option:selected", $(parent).find("." + self._default.selectDataBaseList)).val();
			if (database == -1) {
				return;
			}
			$container = $(parent).find("." + self._default.actionResultContainer);
			$container.html("Loading...");
			$(parent).find("." + self._default.applicationOptionClass).hide();
			$(parent).find("." + self._default.nextButtonContainerClass).hide();
			var date = new Date();
			var id = "container_id_" + date.getTime();
			$container.attr("id", id);
			var func = function() {
				self._callback(parent, self);
			}
			var arr = database.split("|");
			var obj = {
				workId : arr[0],
				fileName : arr[1],
				baseSequence : self._baseSequence,
				tooltip : self._tooltip,
				callback : func
			};
			if (method === "MotifExpress") {
				$(parent).find("." + self._default.applicationOptionClass).show();
				var appOption = $(parent).find("." + self._default.applicationOptionClass + " input[name=applicationOption]:checked").val();
				if (!appOption) {
					appOption = "max";
					$(parent).find("." + self._default.applicationOptionClass + " input[name=applicationOption][value='max']").attr("checked", true);
				}
				obj.applicationOption = appOption;
				$(parent).find("." + self._default.applicationOptionClass).unbind('click');
				$(parent).find("." + self._default.applicationOptionClass).click(function() {
					$(parent).find("." + self._default.nextButtonContainerClass).hide();
					$("#" + id).html("");
					obj.applicationOption = $(this).find("input[name=applicationOption]:checked").val();
					eval(method)(id, obj);
				});
			}
			eval(method)(id, obj);
		});
	},
	
	_loadPluginScriptList : function(workId, fileName, property) {
		var getTripleList = function(tripleList) {
			$.each(tripleList, function(tKey, tVal) {
				LinkDataUtil.loadScript(tVal.object);
			});
		}
		LinkData.getTriplesByProperty(workId, fileName, property, getTripleList);
	},
	
	_changeMethodList : function(dbKey) {
		var self = this;
		var $select = $("." + self._default.appContainerClass + " ." + self._default.selectMethodList);
		$select.attr("title", self._getToolTip(self._tooltipName.selectTool));
		$("option", $select).remove();
		$select.append("<option value='-1' selected='selected'>-- Select Tool --</option>");
		if (dbKey == -1) {
			return;
		}
		var arr = dbKey.split("|");
		var workId = arr[0];
		var fileName = arr[1];
		$.each(self._methodList, function(key, method) {
			self._addValidMethod($select, workId, fileName, method);
		});
	},
	
	_addValidMethod : function($select, workId, fileName, method) {
		var self = this;
		var getFilesByTag = function(fileList) {
			if (!fileList) {
				return;
			}
			$.each(fileList, function(fKey, fName) {
				if (fName === fileName) {
					var tooltip = self._getToolTipByToolName(method);
					tooltip = (tooltip) ? tooltip : "";
					$select.append("<option value='" + method + "' title='" + tooltip + "'>" + method + "</option>");
					return false;
				}
			});
		}
		LinkData.getFilesByTag(workId, method, getFilesByTag);
	},
	
	_initUseButtonListener : function() {
		var self = this;
		$("#" + self._default.baseSequenceContainerId + " ." + self._default.useButtonClass).click(function() {
			self._initDefaultContainer();
			$txtSeq = $("#" + self._default.baseSequenceContainerId + " ." + self._default.baseSequenceClass);
			$fixedSeq = $("#" + self._default.baseSequenceContainerId + " ." + self._default.fixedSequenceClass);
			self._hideError();
			if ($txtSeq.val().length > self._default.baseSequenceMaxLength) {
				self._showError(self._default.errorMessageMaximumSequence.replace("{0}", self._default.baseSequenceMaxLength));
				return;
			}
			if ($txtSeq.val().length < self._default.baseSequenceMaxLength) {
				var tmpVal = $txtSeq.val();
				var eVal = self._getExtraDefaultSequence(self._default.baseSequenceMaxLength - $txtSeq.val().length);
				$txtSeq.val(eVal + tmpVal);
				$("#" + self._default.baseSequenceContainerId + " ." + self._default.baseSequenceClass).attr("size", 500);
			}
			self._baseSequence = $txtSeq.val() + $fixedSeq.html();
			if (!self._baseSequence || self._baseSequence.length < self._default.baseSequenceMinLength) {
				self._showError(self._default.errorMessageEnterSequence.replace("{0}", self._default.baseSequenceMinLength));
			} else {
				$txtSeq.attr('readonly', true).addClass("noborder");
				$(this).hide();
				$("." + self._default.appContainerClass).show();
			}
		});
		
		var timer = new Application.timer();
		var applyStartButToolTip = function() {
			var toolTip = self._getToolTip(self._tooltipName.start);
			if (toolTip) {
				$("#" + self._default.baseSequenceContainerId + " ." + self._default.useButtonClass).attr("title", toolTip);
			} else {   
				timer.call(applyStartButToolTip);
			}
		}
  		applyStartButToolTip();
	},
	
	_callback : function(parent, self) {
		$(parent).find("." + self._default.nextButtonContainerClass).show();
		$(parent).find("." + self._default.finishSequence).hide();
		$("." + self._default.appContainerClass + " ." + self._default.nextButtonClass).attr("title", self._getToolTip(self._tooltipName.next));
		$("." + self._default.appContainerClass + " ." + self._default.finishNowButtonClass).attr("title", self._getToolTip(self._tooltipName.finishNow));
		self._initNextButtonListener();
		self._initFinishNowButtonListener();
	},
	
	_initNextButtonListener : function() {
		var self = this;
		$("." + self._default.appContainerClass + " ." + self._default.nextButtonClass).unbind('click');
		$("." + self._default.appContainerClass + " ." + self._default.nextButtonClass).click(function() {
			$parent = $(this).closest("." + self._default.appContainerClass);
			$parent.find("." + self._default.nextButtonContainerClass).hide();
			$(parent).find("." + self._default.finishSequence).hide()
			var clone = $parent.clone(true);
			$(clone).find("." + self._default.applicationOptionClass).hide();
			var text = $(clone).find(".replaceSequence").text();
			if (text && text.trim().length != 0) {
				self._baseSequence = text;
			}
			$(clone).find("." + self._default.actionResultContainer).html("");
			$(clone).find("." + self._default.nextButtonContainerClass).hide();
			$parent.parent().append(clone);
		});
	},
	
	_initFinishNowButtonListener : function() {
		var self = this;
		$("." + self._default.appContainerClass + " ." + self._default.finishNowButtonClass).unbind('click');
		$("." + self._default.appContainerClass + " ." + self._default.finishNowButtonClass).click(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$(parent).find("." + self._default.nextButtonContainerClass).hide();
			$(parent).find("." + self._default.finishSequence).hide()
			var gene = $(parent).find(".replaceSequence .gene").val();
			var geneType = $(parent).find(".replaceSequence .geneType").val();
			var callback = function(bSequence) {
				self._showFinishedBaseSequence(parent, bSequence);
			}
			self._appBaseLineSequence.getBaseSequence(gene, geneType, callback);
		});
	},
	
	_showFinishedBaseSequence : function(parent, bSequence) {
		var self = this;
		var defaultSequence = $(parent).find(".replaceSequence").text()
		var html = self._getFinishedBaseSequence(defaultSequence, bSequence);
		$(parent).find("." + self._default.finishSequence).show()
		$(parent).find("." + self._default.finishSequence).html(html);
		$(parent).find("." + self._default.finishSequence).scrollLeft(10000);
	},
	
	_getFinishedBaseSequence : function(defaultSequence, bSequence) {
		var self = this, sb = [];
		for (var i = 0; i < defaultSequence.length; i++) {
			var dChar = defaultSequence.charAt(i);
			var bChar = bSequence.charAt(i);
			if (bChar) {
				if (dChar !== self.CHAR_SEQ_EMPTY) {
					sb[sb.length] = "<span class='highlight-sequence'><span class='replace'>" + dChar + "</span></span>";
				} else {
					sb[sb.length] = bChar;
				}
			} else {
				sb[sb.length] = "<span class='highlight-sequence'><span class='replace'>" + dChar + "</span></span>";
			}
		}
		return sb.join("");
	},
	
	_getExtraDefaultSequence : function(count) {
		var self = this, sb = [];
		for (var i = 0; i < count; i++) {
			sb[sb.length] = self.CHAR_SEQ_EMPTY;
		}
		return sb.join("");
	},
	
	_getDatabaseOptionKey : function(workId, fileName) {
		return workId + "|" + fileName;
	},
	
	_getLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	_showError : function(message) {
		var self = this;
		$errMsgEl = $("#" + self._default.baseSequenceContainerId + " ." + self._default.baseErrorMessageClass);
		$errMsgEl.html(message);
		$errMsgEl.show();
	},
	
	_hideError : function() {
		var self = this;
		$("#" + self._default.baseSequenceContainerId + " ." + self._default.baseErrorMessageClass).hide();
	},
	
	_getToolTipByFileName : function(fileName) {
		var self = this;
		if (fileName) {
			if (fileName.toLowerCase().indexOf(self._tooltipName.atGeneExpress) > -1) {
				return self._getToolTip(self._tooltipName.atGeneExpress);
			} else if (fileName.toLowerCase().indexOf(self._tooltipName.diunal) > -1) {
				return self._getToolTip(self._tooltipName.diunal);
			}
		}
	},
	
	_getToolTipByToolName : function(tool) {
		var self = this;
		if (tool) {
			if (tool.toLowerCase().indexOf(self._tooltipName.motifExpress) > -1) {
				return self._getToolTip(self._tooltipName.motifExpress);
			} else if (tool.toLowerCase().indexOf(self._tooltipName.motifCircatian) > -1) {
				return self._getToolTip(self._tooltipName.motifCircatian);
			} else if (tool.toLowerCase().indexOf(self._tooltipName.motifRank) > -1) {
				return self._getToolTip(self._tooltipName.motifRank);
			} else if (tool.toLowerCase().indexOf(self._tooltipName.motifQuery) > -1) {
				return self._getToolTip(self._tooltipName.motifQuery);
			}
		}
	},
	
	_getToolTip : function(key) {
		return this._tooltip.getByKey(key);
	}
	
};

Application.baseLineSequence = function() {
	this._init.apply(this, arguments);
};

Application.baseLineSequence.prototype = {
	
	_attedSequenceInfo : null,
	_ppdbSequenceInfo : null,
	
	_default : {
		sequenceProperty : "sequence"
	},
	
	_tag : {
		attedBaseSequenceTag : "atted_baseLineSequence",
		ppdbBaseSequenceTag : "ppdb_baseLineSequence"
	},
	
	_init : function() {
		this._attedSequenceInfo = {};
		this._ppdbSequenceInfo = {};
		this._initBaseSequenceFile();
	},
	
	_initBaseSequenceFile : function() {
		this._initAttedBaseSequenceFile();
		this._initPpdbBaseSequenceFile();
	},
	
	_initAttedBaseSequenceFile : function() {
		var self = this;
		var getFilesByTag = function(resultList) {
			$.each(resultList, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._initAttedInfo(workId, fileName);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, self._tag.attedBaseSequenceTag, getFilesByTag);
	},
	
	_initPpdbBaseSequenceFile : function() {
		var self = this;
		var getFilesByTag = function(resultList) {
			$.each(resultList, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._initPpdbInfo(workId, fileName);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, self._tag.ppdbBaseSequenceTag, getFilesByTag);
	},
	
	_initAttedInfo : function(workId, fileName) {
		var self = this;
		var getProperties = function(propertyList) {
			$.each(propertyList, function(pKey, pValue) {
				if (pValue.indexOf(self._default.sequenceProperty) > -1) {
					self._attedSequenceInfo.workId = workId;
					self._attedSequenceInfo.fileName = fileName;
					self._attedSequenceInfo.property = pValue;
					return false;
				}
			});
		}
		LinkData.getProperties(workId, fileName, getProperties);
	},
	
	_initPpdbInfo : function(workId, fileName) {
		var self = this;
		var getProperties = function(propertyList) {
			$.each(propertyList, function(pKey, pValue) {
				if (pValue.indexOf(self._default.sequenceProperty) > -1) {
					self._ppdbSequenceInfo.workId = workId;
					self._ppdbSequenceInfo.fileName = fileName;
					self._ppdbSequenceInfo.property = pValue;
					return false;
				}
			});
		}
		LinkData.getProperties(workId, fileName, getProperties);
	},
	
	_getAttedSubjectUrl : function(gene) {
		return "http://atted.jp/data/locus/" + gene + ".html";
	},
	
	_getPpdbSubjectUrl : function(gene) {
		return "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene=" + gene;
	},
	
	_getAttedBaseSequence : function(gene, callback) {
		var self = this;
		var workId = self._attedSequenceInfo.workId;
		var fileName = self._attedSequenceInfo.fileName;
		var property = self._attedSequenceInfo.property;
		var subject = self._getAttedSubjectUrl(gene);
		var getObjects = function(objList) {
			callback(objList[0]);
		}
		LinkData.getObjects(workId, fileName, subject, property, getObjects);
	},
	
	_getPpdbBaseSequence : function(gene, callback) {
		var self = this;
		var workId = self._ppdbSequenceInfo.workId;
		var fileName = self._ppdbSequenceInfo.fileName;
		var property = self._ppdbSequenceInfo.property;
		var subject = self._getPpdbSubjectUrl(gene);
		var getObjects = function(objList) {
			callback(objList[0]);
		}
		LinkData.getObjects(workId, fileName, subject, property, getObjects);
	},
	
	getBaseSequence : function(gene, geneType, callback) {
		var self = this;
		if ("ATTED" === geneType) {
			self._getAttedBaseSequence(gene, callback);
		} else if ("PPDB" === geneType) {
			self._getPpdbBaseSequence(gene, callback);
		} else {
			// error
		}
	}
	
};

Application.tooltip = function() {
	this._init.apply(this, arguments);
};

Application.tooltip.prototype = {
	
	_toolTipList : null,
	
	_default : {
		explanationProperty : "explanation"
	},
	
	_init : function() {
		this._toolTipList = [];
		this._initToolTip();
	},
	
	_initToolTip : function() {
		var self = this;
		var getFilesByTag = function(resultList) {
			$.each(resultList, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._getFilePropertyList(workId, fileName);
				});
			});
		}
		LinkData.getFilesByTag(null, "tooltip", getFilesByTag);
	},
	
	_getFilePropertyList : function(workId, fileName) {
		var self = this;
		var index = new Application.index(1, 10000);
		var getProperties = function(propertyList) {
			$.each(propertyList, function(pKey, pValue) {
				if (pValue.indexOf(self._default.explanationProperty) > -1) {
					self._getSubjectList(workId, fileName, pValue, index);
					return false;
				}
			});
		}
		LinkData.getProperties(workId, fileName, getProperties);
	},
	
	_getSubjectList : function(workId, fileName, property, index) {
		var self = this;
		var getSubjects = function(subjectList) {
			self._getPropertyList(subjectList, workId, fileName, property, index);
		}
		LinkData.getSubjects(workId, fileName, getSubjects, index);
	},
	
	_getPropertyList : function(subjectList, workId, fileName, property, index) {
		var self = this;
		var getTriplesByProperty = function(tripleList) {
			self._addToolTipToList(subjectList, tripleList, workId, fileName, property, index);
		}
		LinkData.getTriplesByProperty(workId, fileName, property, getTriplesByProperty, index);
	},
	
	_addToolTipToList : function(subjectList, tripleList, workId, fileName, property, index) {
		var self = this;
		//if (!tripleList) {
			//return;
		//}
		for (var i = 0; i < subjectList.length; i++) {
			//if (tripleList[i]) {
				var key = self._getLabelAfterHash(subjectList[i]);
				var value = tripleList[i].object;
				self._addToolTip(key, value);
			//}
		}
		if (subjectList && subjectList.length == index.getItemCount()) {
			self._getSubjectList(workId, fileName, property, index.increment());
		}
	},
	
	_addToolTip : function(key, tooltip) {
		var obj = {};
		obj.key = key;
		obj.tooltip = tooltip;
		this._toolTipList.push(obj);
	},
	
	getByKey : function(key) {
		var self = this, tooltip;
		$.each(self._toolTipList, function(objKey, obj) {
			if (obj.key === key) {
				tooltip = obj.tooltip;
				return false;
			}
		});
		return (tooltip) ? tooltip : "";
	},
	
	_getLabelAfterHash : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	}
	
};

Application.index = function() {
	this._init.apply(this, arguments);
}

Application.index.prototype = {
	
	_start : null,
	_end : null,
	
	_init : function(start, end) {
		this._start = start;
		this._end = end;
	},
	
	getIndex : function() {
		return {start : this._start, end : this._end};
	},
	
	getItemCount : function() {
		return (this._end - this._start + 1);
	},
	
	increment : function() {
		var itemCount = this.getItemCount();
		this._start = this._start + itemCount;
		this._end = this._end + itemCount;
		return {start : this._start, end : this._end};
	},
	
	getStartIndex : function() {
		return this._start;
	},
	
	getEndIndex : function() {
		return this._end;
	}
	
};

Application.timer = function() {
	this._init.apply(this, arguments);
};

Application.timer.prototype = {
	
	_delay : null,
	_retry : null,
	_maxRetry : null,
	
	_init : function() {
		this._delay = 1000;
		this._retry = 0;
		this._maxRetry = 100;
	},
	
	call : function(func) {
		if (this._retry < this._maxRetry) {
			setTimeout(func, this._delay);
		}
		this._retry++;
	}
};

$(document).ready(function() {
	new Application.genocon();
});
