/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/

// Implement forEach for IE
// Production steps of ECMA-262, Edition 5, 15.4.4.18
// Reference: http://es5.github.io/#x15.4.4.18
if (!Array.prototype.forEach) {

  Array.prototype.forEach = function(callback/*, thisArg*/) {

    var T, k;

    if (this == null) {
      throw new TypeError('this is null or not defined');
    }

    // 1. Let O be the result of calling toObject() passing the
    // |this| value as the argument.
    var O = Object(this);

    // 2. Let lenValue be the result of calling the Get() internal
    // method of O with the argument "length".
    // 3. Let len be toUint32(lenValue).
    var len = O.length >>> 0;

    // 4. If isCallable(callback) is false, throw a TypeError exception. 
    // See: http://es5.github.com/#x9.11
    if (typeof callback !== 'function') {
      throw new TypeError(callback + ' is not a function');
    }

    // 5. If thisArg was supplied, let T be thisArg; else let
    // T be undefined.
    if (arguments.length > 1) {
      T = arguments[1];
    }

    // 6. Let k be 0.
    k = 0;

    // 7. Repeat while k < len.
    while (k < len) {

      var kValue;

      // a. Let Pk be ToString(k).
      //    This is implicit for LHS operands of the in operator.
      // b. Let kPresent be the result of calling the HasProperty
      //    internal method of O with argument Pk.
      //    This step can be combined with c.
      // c. If kPresent is true, then
      if (k in O) {

        // i. Let kValue be the result of calling the Get internal
        // method of O with argument Pk.
        kValue = O[k];

        // ii. Call the Call internal method of callback with T as
        // the this value and argument list containing kValue, k, and O.
        callback.call(T, kValue, k, O);
      }
      // d. Increase k by 1.
      k++;
    }
    // 8. return undefined.
  };
}

data_url = "http://linkdata.org/property/rdf1s8278i" // データテーブルのURLを指定
var all_data; 
var flgArea = []; // 学区領域表示切替用のフラグ

function initialize(){
	all_data = new Array();
	// データをLinkDataから取得 
	tmp_a_data = new Array();
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var tmp_data = {}
				tmp_data["id"] = subjValue;
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						if(propValue == data_url+"#"+encodeURIComponent("施設名")){
							tmp_data["name"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("tag")){
							tmp_data["tag"] = objValue;
						}else if(propValue == data_url+"#lat"){
							tmp_data["lat"] = objValue;
						}else if(propValue == data_url+"#long"){
							tmp_data["lng"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("住所")){
							tmp_data["location"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("電話番号")){
							tmp_data["phoneNumber"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("区分")){
							tmp_data["schoolType"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("対象年齢")){
							tmp_data["age"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("定員")){
							tmp_data["capacity"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("短時間")){
							tmp_data["shortTime"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("標準時間")){
							tmp_data["standardTime"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("早朝保育")){
							tmp_data["earlyMorning"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("延長保育")){
							tmp_data["extension"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("一時保育")){
							tmp_data["temporary"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("休日保育")){
							tmp_data["holiday"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("設置者")){
							tmp_data["owner"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("認可")){
							tmp_data["permission"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("所属小学校区")){
							tmp_data["pArea"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("所属中学校区")){
							tmp_data["jsArea"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLat1")){
							tmp_data["arealat1"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLong1")){
							tmp_data["arealng1"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLat2")){
							tmp_data["arealat2"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLong2")){
							tmp_data["arealng2"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLat3")){
							tmp_data["arealat3"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLong3")){
							tmp_data["arealng3"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLat4")){
							tmp_data["arealat4"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLong4")){
							tmp_data["arealng4"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLat5")){
							tmp_data["arealat5"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLong5")){
							tmp_data["arealng5"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLat6")){
							tmp_data["arealat6"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLong6")){
							tmp_data["arealng6"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLat7")){
							tmp_data["arealat7"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLong7")){
							tmp_data["arealng7"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLat8")){
							tmp_data["arealat8"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLong8")){
							tmp_data["arealng8"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLat9")){
							tmp_data["arealat9"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLong9")){
							tmp_data["arealng9"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLat10")){
							tmp_data["arealat10"] = objValue;
						}else if(propValue == data_url+"#"+encodeURIComponent("areaLong10")){
							tmp_data["arealng10"] = objValue;
						}// データを増やす場合はここに追加
					});
				});
				tmp_a_data.push(tmp_data);
			});
		});
	});
	//全データ
	all_data = tmp_a_data;

	//地図センター緯度経度の初期値は「燕市役所」
	var myLatLng = new google.maps.LatLng(37.673215,138.882446);
	var myMap = new google.maps.Map(document.getElementById('result'), {
		zoom: 12,
		center: myLatLng,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		scaleControl: true,
		scrollwheel: true,
		draggable: true
	});
	
	//ポイントの設定
	var latlng;
	var data = new Array();
	
	// 表示切替用に各種変数を初期化(初期値は表示されない)
	// infoWindowを初期化
	var infoWindow = new google.maps.InfoWindow({
		position:new google.maps.LatLng(37.673215,138.882446),
		content:"ここが燕市役所"
	});
	// 学校区域を初期化
	var myArea = new google.maps.Polygon( {
		map: myMap,
		paths:[new google.maps.LatLng( 37.673215,138.882446 ) ],
		fillColor: "aqua",
		fillOpacity: 0.12,
		strokeWeight: 0.5,
	});
	
	// データ数に応じたフラグの初期化
	for (var i in all_data) {
		flgArea.push(false);
	}
	
	// 全データの設定に関するループ
	for (var i in all_data) {
		// アイコン画像のURLを指定
		switch (all_data[i].tag) { // タグで保小中を区別
			case '1': // 幼・保育園
				icon = "http://app.linkdata.org/asset/e7603306.png";
				break;
			case '2': // 小学校
				icon = "http://app.linkdata.org/asset/ca5f4430.png";
				break;
			case '3': // 中学校
				icon = "http://app.linkdata.org/asset/2cf90af2.png";
				break;
			case '4': // 公民館
				icon = "http://app.linkdata.org/asset/fe7d725c.png";
				break;
			case '5': // 文化センター，産業史料館
				icon = "http://app.linkdata.org/asset/4bc2c9e0.png";
				break;
			case '6': // 体育センター
				icon = "http://app.linkdata.org/asset/660f5adb.png";
				break;
			default: // タグ設定ミスの場合
				icon = "http://app.linkdata.org/asset/4e5c944d.png"; // ？マークを表示
				break;
		}
		// アイコン画像を描画
		var image = {
   			url : icon,
    		scaledSize : new google.maps.Size(32, 32)
  		}
		var gmarker = new google.maps.Marker({  
			position: new google.maps.LatLng(all_data[i].lat,all_data[i].lng),       // 緯度・経度は地図の中心  
			title: all_data[i].name,// ツールチップ 
			openInfo:true,
			icon: image,
			map: myMap  
	 	}); 
		// ウィンドウに表示するデータをつくる
		var spot_info = all_data[i].name + "<small>"
			+ '<br>　　【住所】' + (all_data[i].location != undefined ? all_data[i].location : '情報なし')
			+ '<br>【電話番号】' + (all_data[i].phoneNumber != undefined ? all_data[i].phoneNumber : '情報なし');
		
		switch (all_data[i].tag) { // タグで保小中を区別
			case '1': // 保
				spot_info = spot_info
					+ '<br>　　【区分】' + (all_data[i].schoolType != undefined ? all_data[i].schoolType : '情報なし')
					+ '<br>【対象児童】' + (all_data[i].age != undefined ? all_data[i].age : '情報なし')
					+ '<br>　　【定員】' + (all_data[i].capacity != undefined ? all_data[i].capacity : '情報なし')
					+ '<br>【開園時間】'
					+ '<br>　　　　短：' + (all_data[i].shortTime != undefined ? all_data[i].shortTime : '情報なし')
					+ '<br>　　　標準：' + (all_data[i].standardTime != undefined ? all_data[i].standardTime : '情報なし')
					+ '<br>【早朝保育】' + (all_data[i].earlyMorning != undefined ? all_data[i].earlyMorning : '情報なし')
					+ '<br>【延長保育】' + (all_data[i].extension != undefined ? all_data[i].extension : '情報なし')
					+ '<br>【一時保育】' + (all_data[i].temporary != undefined ? all_data[i].temporary : '情報なし')
					+ '<br>【休日保育】' + (all_data[i].holiday != undefined ? all_data[i].holiday : '情報なし')
					+ '<br>　【設置者】' + (all_data[i].owner != undefined ? all_data[i].owner : '情報なし')
					+ '<br>　　【認可】' + (all_data[i].permission != undefined ? all_data[i].permission : '情報なし')
					+ '<br>【小学校区】' + (all_data[i].pArea != undefined ? all_data[i].pArea : '情報なし');// データを増やす場合はここに追加
				break;
			case '2': // 小
				spot_info = spot_info
					+ '<br>　　【区分】' + (all_data[i].schoolType != undefined ? all_data[i].schoolType : '情報なし')
					+ '<br>【中学校区】' + (all_data[i].jsArea != undefined ? all_data[i].jsArea : '情報なし')
					+ '<br>【学校区域】水色で表示';
				break;
			case '3': // 中
				spot_info = spot_info
					+ '<br>　　【区分】' + (all_data[i].schoolType != undefined ? all_data[i].schoolType : '情報なし')
					+ '<br>【学校区域】赤色で表示';
			default:
				break;
		}
			
		data.push({
			position: new google.maps.LatLng(all_data[i].lat, all_data[i].lng), 
			content: spot_info
		});
		
		// 領域1を設定
		var areaLat1 = all_data[i].arealat1;
		var areaLats1 = areaLat1.split(",");
		var areaLng1 = all_data[i].arealng1;
		var areaLngs1 = areaLng1.split(",");
		var patharray1 = new Array();
		for (var k = 0; k < areaLats1.length; k++) {
 			patharray1[k] = new google.maps.LatLng(areaLats1[k], areaLngs1[k]);
		}
		// 領域2を設定
		var areaLat2 = all_data[i].arealat2;
		var areaLats2 = areaLat2.split(",");
		var areaLng2 = all_data[i].arealng2;
		var areaLngs2 = areaLng2.split(",");
		var patharray2 = new Array();
		for (var k = 0; k < areaLats2.length; k++) {
 			patharray2[k] = new google.maps.LatLng(areaLats2[k], areaLngs2[k]);
		}
		// 領域3を設定
		var areaLat3 = all_data[i].arealat3;
		var areaLats3 = areaLat3.split(",");
		var areaLng3 = all_data[i].arealng3;
		var areaLngs3 = areaLng3.split(",");
		var patharray3 = new Array();
		for (var k = 0; k < areaLats3.length; k++) {
 			patharray3[k] = new google.maps.LatLng(areaLats3[k], areaLngs3[k]);
		}
		// 領域4を設定
		var areaLat4 = all_data[i].arealat4;
		var areaLats4 = areaLat4.split(",");
		var areaLng4 = all_data[i].arealng4;
		var areaLngs4 = areaLng4.split(",");
		var patharray4 = new Array();
		for (var k = 0; k < areaLats4.length; k++) {
 			patharray4[k] = new google.maps.LatLng(areaLats4[k], areaLngs4[k]);
		}
		// 領域5を設定
		var areaLat5 = all_data[i].arealat5;
		var areaLats5 = areaLat5.split(",");
		var areaLng5 = all_data[i].arealng5;
		var areaLngs5 = areaLng5.split(",");
		var patharray5 = new Array();
		for (var k = 0; k < areaLats5.length; k++) {
 			patharray5[k] = new google.maps.LatLng(areaLats5[k], areaLngs5[k]);
		}
		// 領域6を設定
		var areaLat6 = all_data[i].arealat6;
		var areaLats6 = areaLat6.split(",");
		var areaLng6 = all_data[i].arealng6;
		var areaLngs6 = areaLng6.split(",");
		var patharray6 = new Array();
		for (var k = 0; k < areaLats6.length; k++) {
 			patharray6[k] = new google.maps.LatLng(areaLats6[k], areaLngs6[k]);
		}
		// 領域7を設定
		var areaLat7 = all_data[i].arealat7;
		var areaLats7 = areaLat7.split(",");
		var areaLng7 = all_data[i].arealng7;
		var areaLngs7 = areaLng7.split(",");
		var patharray7 = new Array();
		for (var k = 0; k < areaLats7.length; k++) {
 			patharray7[k] = new google.maps.LatLng(areaLats7[k], areaLngs7[k]);
		}
		// 領域8を設定
		var areaLat8 = all_data[i].arealat8;
		var areaLats8 = areaLat8.split(",");
		var areaLng8 = all_data[i].arealng8;
		var areaLngs8 = areaLng8.split(",");
		var patharray8 = new Array();
		for (var k = 0; k < areaLats8.length; k++) {
 			patharray8[k] = new google.maps.LatLng(areaLats8[k], areaLngs8[k]);
		}
		// 領域9を設定
		var areaLat9 = all_data[i].arealat9;
		var areaLats9 = areaLat9.split(",");
		var areaLng9 = all_data[i].arealng9;
		var areaLngs9 = areaLng9.split(",");
		var patharray9 = new Array();
		for (var k = 0; k < areaLats9.length; k++) {
 			patharray9[k] = new google.maps.LatLng(areaLats9[k], areaLngs9[k]);
		}
		// 領域10を設定
		var areaLat10 = all_data[i].arealat10;
		var areaLats10 = areaLat10.split(",");
		var areaLng10 = all_data[i].arealng10;
		var areaLngs10 = areaLng10.split(",");
		var patharray10 = new Array();
		for (var k = 0; k < areaLats10.length; k++) {
 			patharray10[k] = new google.maps.LatLng(areaLats10[k], areaLngs10[k]);
		}
		// 各マーカの情報表示および学校区域の可視化
		flgArea[i] = attachMessage(gmarker, data[i].content, myMap, patharray1, patharray2, patharray3, patharray4, patharray5, patharray6, patharray7, patharray8, patharray9, patharray10, infoWindow, myArea, flgArea[i], all_data[i].tag);
	}; //for toji 
};//initialize toji

// 地図のマーカーをクリックするとウィンドウを表示する処理
function attachMessage(marker, msg, map, pathArray1, pathArray2, pathArray3, pathArray4, pathArray5, pathArray6, pathArray7, pathArray8, pathArray9, pathArray10, infowindow, myArea, flgArea, i, dataTag) {
	google.maps.event.addListener(marker, 'click', function() {
	// 基本情報表示
	infowindow.setContent(msg);
	infowindow.open(map, marker);
	if(flgArea == false){
		// 学校区域可視化
		myArea = new google.maps.Polygon( {
					paths: [pathArray1,pathArray2,pathArray3,pathArray4,pathArray5,pathArray6,pathArray7,pathArray8,pathArray9,pathArray10],
					fillColor: i==2?"aqua":"tomato",
					fillOpacity: 0.12,
					strokeWeight: 0.5
				});
		myArea.setMap(map);
		flgArea = true; // フラグを更新
	} else {
		// 学校区域非表示
		myArea.setMap(null);
		flgArea = false; // フラグを更新
	}
	return flgArea;
	});
};
window.onload = function() {
    $(function(){initialize();});	
};
