/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/
const DataID	= 'rdf1s1191i';
const LinkDataPropUrl = 'http://linkdata.org/property/' + DataID + '#';

var all_data;        
function initialize(){
	all_data = new Array();
	// データをLinkDataから取得 
	tmp_a_data = new Array();
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var tmp_data = {}
				tmp_data["id"] = subjValue;
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						switch (propValue) {
							case LinkDataPropUrl + encodeURIComponent('施設名称'):
								tmp_data["name"] = objValue;
								break;
							case LinkDataPropUrl + encodeURIComponent('施設名称'):
								tmp_data["address"] = objValue;
								break;
							case LinkDataPropUrl + encodeURIComponent("電話番号"):
								tmp_data["telnum"] = objValue;
								break;
							case LinkDataPropUrl + encodeURIComponent("緯度"):
							case "http://www.w3.org/2003/01/geo/wgs84_pos#lat":
								tmp_data["lat"] = objValue;
								break;
							case LinkDataPropUrl + encodeURIComponent("経度"):
							case "http://www.w3.org/2003/01/geo/wgs84_pos#long":
								tmp_data["lng"] = objValue;
								break;
							case LinkDataPropUrl + encodeURIComponent("開館時間"):
								tmp_data["openHour"] = objValue;
								break;
							case LinkDataPropUrl + encodeURIComponent("休館日"):
								tmp_data["closeDay"] = objValue;
								break;
						}
						// console.log(tmp_data);
					});
				});
				tmp_a_data.push(tmp_data);
			});
		});
	});
	//全データ
	all_data = tmp_a_data;

	//地図センター緯度経度の初期値は「福井市役所」
	var myLatLng = new google.maps.LatLng(36.0640618,136.2195398);
	var myMap = new google.maps.Map(document.getElementById('result'), {
		zoom: 14,
		center: myLatLng,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		scaleControl: true,
		scrollwheel: true,
		draggable: true
	});
 
	//ポイントの設定
	var latlng;
	var data = new Array();

	for (var i in all_data) {
		//避難所の種類で区分する
		var gmarker = new google.maps.Marker({  
			position: new google.maps.LatLng(all_data[i].lat,all_data[i].lng),  
			title: all_data[i].name,// ツールチップ 
			openInfo:true,
			map: myMap, 
			icon: {
            	url: 'http://app.linkdata.org/asset/8cd9a87e.png',
            	scaledSize : new google.maps.Size(40,40)
        	}
		}); 
		// ウィンドウに表示するデータをつくる
		var spot_info = '<B>[' + i + ']' + all_data[i].name + '</B><small>'
			+ '<br>【住所】'	+	(all_data[i].address != undefined ? ( all_data[i].address): '' )
			+ '<br>【電話番号】'	+ 	(all_data[i].telnum != undefined ? ( all_data[i].telnum) : '')
			+ '<br>【開館時間】'	+	(all_data[i].openHour != undefined ? ( all_data[i].openHour) : '')
			+ '<br>【休館日】' 	+	(all_data[i].closeDay != undefined ? ( all_data[i].closeDay) : '')
			+ '<br><a href="https://www.city.fukui.lg.jp/index.html" target="_blank")><b>福井市ホームページ</b></a>'
			+ '</small>';
		
		data.push({
			position: new google.maps.LatLng(all_data[i].lat, all_data[i].lng), 
			content: spot_info
		});
		// 地図上にウィンドウで表示
		attachMessage(gmarker, data[i].content);
		console.log(data[i].content);
	};
};

// 地図のマーカーをクリックするとウィンドウを表示する処理
function attachMessage(marker, msg) {
	google.maps.event.addListener(marker, 'click', function(event) {
    	new google.maps.InfoWindow({
			content: msg
        }).open(marker.getMap(), marker);
    });
};
window.onload = function() {
    $(function(){initialize();});	
};
