if (typeof Application == "undefined" || !Application) {
	var Application = {};
}

Application.genocon = function() {
	this._init.apply(this, arguments);
};

Application.genocon.prototype = {
	
	CHAR_SEQ_EMPTY : "-",
	
	_baseSequence : null,
	_tooltip : null,
	_methodList : null,
	_appBaseLineSequence : null,
	_appMenuHandler : null,
	
	_default : {
		baseSequenceContainerId : "baseSequenceContainer",
		fixedSequenceClass : "fixedSequence",
		finishSequence : "finishSequence",
		baseErrorMessageClass : "baseErrorMessage",
		errorMessageEnterSequence : "Please enter a sequence of minimum length {0}",
		errorMessageMaximumSequence : "Please enter a sequence of maximum length {0}",
		useButtonClass : "useButton",
		nextButtonClass : "nextButton",
		finishNowButtonClass : "finishNow",
		nextButtonContainerClass : "nextButtonContainer",
		collapseButton : "collapseButton",
		expandButton : "expandButton",
		removeButton : "removeButton",
		appContainerClass : "applicationContainer",
		appDataContainerClass : "applicationDataContainer",
		actionButtonContainer : "actionButtonContainer",
		actionResultContainer : "actionResultContainer",
		baseSequenceBoxClass : "baseSequenceBox",
		baseSequenceClass : "baseSequence",
		selectDataBaseList : "databaseList",
		selectMethodList : "optionList",
		databaseFilteringProperty : "#motif%20sequence",
		methodUrlProperty : "#application%20URL",
		baseSequenceMinLength : 50,
		baseSequenceMaxLength : 500,
		applicationOptionClass : "applicationOptionRadio",
		analysisMethodComboClass : "analysisMethod",
		expressionDbComboClass : "expressionDb",
		dataColomboClass : "dataCol",
		analysisMethodContainer : "analysisMethodContainer",
		expressionDbContainer : "expressionDbContainer",
		dataColContainer : "dataColContainer",
		chkEmptySequenceId : "chkEmptySequnce",
		analysisMethodComboEmptyOptionText : "-- Select Analysis Method --",
		expressionDbComboEmptyOptionText : "-- Select Expression Database --",
		dataColColomboEmptyOptionText : "-- Select Data Collection --",
		manualMotifEntryToolName : "InputMotif",
		itemLabelPostfix : "Label",
		finishSequenceFixedClass : "finishSequenceFixed"
	},
	
	_tag : {
		databaseTag : "database",
		methodTag : "method"
	},
	
	_tooltipName : {
		atGeneExpress : "atgenexpress",
		diurnal : "diurnal",
		selectDatabase : "selectdatabase",
		selectTool : "Select Tool",
		motifExpress : "motifexpress",
		motifCircatian : "motifcircadian",
		motifRank : "motifrank",
		motifQuery : "motifquery",
		inputMotif : "inputmotif",
		defaultSequence : "Base Sequence",
		fixedSequence : "gacccttcctctatataaggaagttcatttcatttggagaggacctcgac",
		finishNow : "Finish Now",
		next : "Next",
		expressionDb : "Expression Database",
		analysisMethod : "Analysis Method",
		dataCollection : "Data Collection",
		baseSequence : "Base Sequence",
		finishNow : "Finish Now",
		startButton : "Start"
		// 追加
		//expressionRanking: "Expression Ranking",
		
	},
	
	_init : function() {
		this._methodList = [];
		this._initToolTip();
		this._initDefaultSequence();
		this._initAppBaseLineSequence();
		this._initLoadScript();
		this._initUseButtonListener();
		this._initAppMenuHanndler();
		this._initAnalysisMethodListener();
		this._initExpressionDbListener();
		this._initDataCollectionListener();
		this._initEmptySequenceCheckBox();
	},
	
	_initToolTip : function() {
		this._tooltip = new Application.tooltip();
	},
	
	_initEmptySequenceCheckBox : function() {
		var self = this;
		$("#" + this._default.chkEmptySequenceId).click(function() {
			if ($(this).is(":checked")) {
				var textArea = $("#" + self._default.baseSequenceContainerId + " ." + self._default.baseSequenceClass)
				$(textArea).attr("value","");
				self._fillEmptyBaseSequence();
				$(textArea).attr("disabled",true);
			} else {
				$("#" + self._default.baseSequenceContainerId + " ." + self._default.baseSequenceClass).attr("disabled",false);
			}
		});
		/* following two lines were added to correct the behaviour, if user just pressed F5 button to 
           refresh the browser. in that case if previously checkbox is unnchecked, even after pressing
           F5, it remains unchecked in the new window
        */
		$("#" + this._default.chkEmptySequenceId).attr("checked","checked");
		$("#" + self._default.baseSequenceContainerId + " ." + self._default.baseSequenceClass).attr("disabled",true);
	},
	
	_initDefaultSequence : function() {
		var self = this;
		this._fillEmptyBaseSequence();
		/*for (var i = 0; i < self._default.baseSequenceMaxLength; i++) {
			sb[sb.length] = self.CHAR_SEQ_EMPTY;
		}
		$baseInput = $("#" + this._default.baseSequenceContainerId + " ." + this._default.baseSequenceClass);
		$baseInput.val(sb.join(""));*/
		
		$baseInput = $("#" + this._default.baseSequenceContainerId + " ." + this._default.baseSequenceClass);
		$baseInput.attr("value",$baseInput.val());
		$baseInput.keyup(function() {
			//var size = ($baseInput.val().length != 0) ? $baseInput.val().length : 1;
			//$baseInput.attr("size", size);
			$baseInput.attr("value", $baseInput.val());
		});
		$("#" + this._default.baseSequenceContainerId + " ." + this._default.baseSequenceBoxClass).scrollLeft(10000);
		var timer = new Application.timer();
		var applyToolTip = function() {
			var dToolTip = self._getToolTip(self._tooltipName.defaultSequence);
			var fToolTip = self._getToolTip(self._tooltipName.fixedSequence);
			var toolToolTip = self._getToolTip(self._tooltipName.selectTool);
			var analysisCmbToolTip = self._getToolTip(self._tooltipName.analysisMethod);
			var expDbToolTip = self._getToolTip(self._tooltipName.expressionDb);
			var dataCollToolTip = self._getToolTip(self._tooltipName.dataCollection);
			var startButToolTip = self._getToolTip(self._tooltipName.startButton);
			if (dToolTip && fToolTip) {
				var labelPostfix = self._default.itemLabelPostfix;
				$("#" + self._default.baseSequenceContainerId + " ." + self._default.baseSequenceClass).attr("title", dToolTip);
				$("#" + self._default.baseSequenceContainerId + " ." + self._default.baseSequenceClass + labelPostfix).attr("title", dToolTip);
				$("#" + self._default.baseSequenceContainerId + " ." + self._default.fixedSequenceClass).attr("title", fToolTip);
				
				$("." + self._default.appContainerClass + " ." + self._default.analysisMethodComboClass).attr("title", analysisCmbToolTip);
				$("." + self._default.appContainerClass + " ." + self._default.analysisMethodComboClass + labelPostfix).attr("title", analysisCmbToolTip);
				
				$("." + self._default.appContainerClass + " ." + self._default.expressionDbComboClass).attr("title", expDbToolTip);
				$("." + self._default.appContainerClass + " ." + self._default.expressionDbComboClass + labelPostfix).attr("title", expDbToolTip);
				
				$("." + self._default.appContainerClass + " ." + self._default.dataColomboClass).attr("title", dataCollToolTip);
				$("." + self._default.appContainerClass + " ." + self._default.dataColomboClass + labelPostfix).attr("title", dataCollToolTip);
				
				$("." + self._default.appContainerClass + " ." + self._default.selectMethodList).attr("title", toolToolTip);
				$("." + self._default.appContainerClass + " ." + self._default.selectMethodList + labelPostfix).attr("title", toolToolTip);
				
				$(" ." + self._default.useButtonClass).attr("title", startButToolTip);
			} else {
				timer.call(applyToolTip);
			}
		}
		applyToolTip();
	},
	
	_initAppBaseLineSequence : function() {
		this._appBaseLineSequence = new Application.baseLineSequence();
	},
	
	_initAppMenuHanndler : function() {
		this._appMenuHandler = new Application.MenuHandler()
	},
	
	_initLoadScript : function() {
		var self = this;
		var getFilesByTag = function(result) {
			$.each(result, function(workId, fileArray){
				$.each(fileArray, function(fileKey, fileName) {
					var getProperties = function(propertytList) {
						$.each(propertytList, function(propKey, propVal) {
							if (propVal.indexOf(self._default.methodUrlProperty) > -1) {
								self._loadPluginScriptList(workId, fileName, propVal);
								return false;
							}
						});
					}
					LinkData.getProperties(workId, fileName, getProperties);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, self._tag.methodTag, getFilesByTag);
	},
	
	_initDefaultContainer : function() {
		//this._initDatabase();
		this._initMethod();
		this._initActionButton();
		//this._initDatabaseListener();
		this._initMethodListener();
	},
	/*
	_initDatabase : function() {
		var self = this;
		var $select = $("." + self._default.appContainerClass + " ." + self._default.selectDataBaseList);
		$select.attr("title", self._getToolTip(self._tooltipName.selectDatabase));
		$("option", $select).remove();
		$select.append("<option value='-1' selected='selected'>-- Select Database --</option>");
		var getFilesByTag = function(result) {
			$.each(result, function(workId, fileArray){
				$.each(fileArray, function(fileKey, fileName) {
					var dbKey = self._getDatabaseOptionKey(workId, fileName);
					var tooltip = self._tooltip.getByKey(fileName);
					$select.append("<option value='" + dbKey + "' title='" + tooltip + "'>" + fileName + "</option>");
				});
			});
		}
		LinkData.getFilesByTag("", self._tag.databaseTag, getFilesByTag);
	},*/
	
	_initMethod : function() {
		var self = this;
		var $select = $("." + self._default.appContainerClass + " ." + self._default.selectMethodList);
		$("option", $select).remove();
		$select.append("<option value='-1' selected='selected'>-- Select Tool --</option>");
		$select.attr("title", self._getToolTip(self._tooltipName.selectTool));
		var getFilesByTag = function(result) {
			$.each(result, function(workId, fileArray){
				$.each(fileArray, function(fileKey, fileName) {
					var getSubjects = function(subjectList) {
						$.each(subjectList, function(subKey, subVal) {
							var label = self._getLabel(subVal);
							var tooltip = self._getToolTipByToolName(label);
							tooltip = (tooltip) ? tooltip : "";
							$select.append("<option value='" + label + "' title='" + tooltip + "'>" + label + "</option>");
							self._methodList.push(label);
						});
					}
					LinkData.getSubjects(workId, fileName, getSubjects);
				});
			});
		}
		LinkData.getFilesByTag(null, self._tag.methodTag, getFilesByTag);
	},
	
	_initActionButton : function() {
		var self = this;
		$("." + self._default.actionButtonContainer + " ." + self._default.collapseButton).click(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$(parent).find("." + self._default.appDataContainerClass).hide();
		});
		$("." + self._default.actionButtonContainer + " ." + self._default.expandButton).click(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$(parent).find("." + self._default.appDataContainerClass).show();
		});
		$("." + self._default.actionButtonContainer + " ." + self._default.removeButton).click(function() {
			if ($("." + self._default.appContainerClass).length == 1) {
				$("." + self._default.appContainerClass).hide();
				$("." + self._default.appContainerClass + " .actionResultContainer").html("");
				//$("." + self._default.appContainerClass + " .databaseList").find.empty();
				//$("." + self._default.appContainerClass + " .optionList").find('option').remove();
				$("#" + self._default.baseSequenceContainerId + " ." + self._default.useButtonClass).show();
			} else {
				$(this).closest("." + self._default.appContainerClass).remove();
			}
		});
	},
	/*
	_initDatabaseListener : function() {
		var self = this;
		var $selectDb = $("." + self._default.appContainerClass + " ." + self._default.selectDataBaseList);
		$selectDb.change(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$(parent).find("." + self._default.applicationOptionClass).hide();
			$(parent).find("." + self._default.selectMethodList + " option").removeAttr("selected");
			$(parent).find("." + self._default.nextButtonContainerClass).hide();
			$container = $(parent).find("." + self._default.actionResultContainer);
			$container.html("");
			var dbKey = $("option:selected", $(this)).val();
			self._changeMethodList(dbKey);
		});
	},*/
	// tool listner
	_initMethodListener : function() {
		var self = this;
		//var $selectDb = $("." + self._default.appContainerClass + " ." + self._default.selectDataBaseList);
		var $select = $("." + self._default.appContainerClass + " ." + self._default.selectMethodList);
		$select.change(function() {
			var selectedTool = $(this).val();
			if (selectedTool != "-1") {
				var parent = $(this).closest("." + self._default.appContainerClass);
				if (selectedTool == self._default.manualMotifEntryToolName) {
					$(parent).find("." + self._default.applicationOptionClass).hide();
					self._showSelectedPlugin(null,$(this));
				} else {
					//self._clearWorkingArea(this);
					self._initMotifExpressOptions(this);
					self._fillAnalysisMethodCombo(this);
					$(parent).find("." + self._default.analysisMethodContainer).show();
				}
				self._resetDataMiningCombos(this);
				//var comboId = "." + self._default.appContainerClass + " ." + self._default.selectMethodList;
				//self._makeTheDomChangeOfComboSelect(comboId,selectedTool);
			}
		});
	},
	
	_makeTheDomChangeOfComboSelect : function(comboSelecter, value) {
		$(comboSelecter + " option").each(function(i){
        	var optionVal = $(this).val();
			if (optionVal == value) {
				$(this).attr("selected",true);
			}
    	});
	},
	
	_initAnalysisMethodListener : function() {

		var self = this;
		var selecter = "." + self._default.appContainerClass + " ." + self._default.analysisMethodComboClass;
		var $select = $(selecter);
		$select.change(function() {
			var selectedAnalysisMethod = $(this).val();
			if (selectedAnalysisMethod != "-1") {
				var parent = $(this).closest("." + self._default.appContainerClass);
				self._fillExpressionDBCombo(this);
				self._resetDataMiningCombos(this);
				$(parent).find("." + self._default.expressionDbContainer).show();
				//self._makeTheDomChangeOfComboSelect(selecter, selectedAnalysisMethod);
			}
		});
	},
	
	_initExpressionDbListener : function() {
		var self = this;
		var selector = "." + self._default.appContainerClass + " ." + self._default.expressionDbComboClass
		var $select = $(selector);
		$select.change(function() {
			var selectedExpressionDb = $(this).val();
			if (selectedExpressionDb != "-1") {
				var parent = $(this).closest("." + self._default.appContainerClass);
				self._fillDataCollectionCombo(this);
				self._resetDataMiningCombos(this);
				$(parent).find("." + self._default.dataColContainer).show();
				//self._makeTheDomChangeOfComboSelect(selector, selectedExpressionDb);
			}
		});
	},
	
	_initDataCollectionListener : function() {
		var self = this;
		var selector = "." + self._default.appContainerClass + " ." + self._default.dataColomboClass;
		var $select = $(selector);
		$select.change(function() {
			var selectedDataCollection = $(this).val();
			if (selectedDataCollection != "-1") {
				self._showSelectedPlugin(selectedDataCollection,$(this));
				//self._makeTheDomChangeOfComboSelect(selector, selectedDataCollection)
			}
		});
	},
	
	_getSelectedTool : function(parentRef) {
		return $(parentRef).find("." + this._default.selectMethodList).val();
	},
	
	_getSelectedAnalysisMethod : function(parentRef) {
		var comboRef = $(parentRef).find("." + this._default.analysisMethodComboClass);
		if (comboRef.length > 0 && comboRef.is(":visible")) {
			return $(comboRef).val();
		} else {
			return "";
		}
		//return $(parentRef).find("." + this._default.analysisMethodComboClass).val();
	},
	
	_initMotifExpressOptions : function(context) {
		var self = this;
		var parent = $(context).closest("." + this._default.appContainerClass);
		$(parent).find("." + self._default.applicationOptionClass).unbind('click');
		var selectedTool = $(context).val();
		if (selectedTool == "MotifExpress") {
			$(parent).find("." + self._default.applicationOptionClass).show();
			$(parent).find("." + self._default.applicationOptionClass).click(function() {
				var selectedDataCollection = $(parent).find("." + self._default.dataColomboClass);
				if ($(selectedDataCollection).is(":visible") && $(selectedDataCollection).val() != "-1") {
					self._showSelectedPlugin(selectedDataCollection.val(),$(this));
					//return;
				}	
				//$(parent).find("." + self._default.nextButtonContainerClass).hide();
				//obj.applicationOption = $(this).find("input[name=applicationOption]:checked").val();
				//eval(method)(id, obj);
			});
			// making motif max as the defaukt mthod
			$(parent).find("." + self._default.applicationOptionClass + " input[name=applicationOption]:checked")[0].checked=true;
		} else {
			$(parent).find("." + self._default.applicationOptionClass).hide();
		}
	},
	
	_resetDataMiningCombos : function(comboRef) {
		var parent = $(comboRef).closest("." + this._default.appContainerClass);
		var expressionDbContainer = $(parent).find("." + this._default.expressionDbContainer);
		var dataColContainer = $(parent).find(" ." + this._default.dataColContainer);
		var analysisMethodContainer = $(parent).find(" ." + this._default.analysisMethodContainer);
		var toolCombo = $(parent).find("." + this._default.selectMethodList);
		var comboClass = $(comboRef).attr("class");
		if (toolCombo.val() == this._default.manualMotifEntryToolName) {
			$(analysisMethodContainer).hide();
			$(expressionDbContainer).hide();
			$(dataColContainer).hide();
		} else {
			if (comboClass == this._default.selectMethodList) {
				$(analysisMethodContainer).show();
				$(expressionDbContainer).hide();
				$(dataColContainer).hide();
			} else if (comboClass == this._default.analysisMethodComboClass) {
				$(expressionDbContainer).hide();
				$(dataColContainer).hide();
			}
			$container = $(parent).find("." + this._default.actionResultContainer);
			$container.html("");
		}
		$(parent).find("." + this._default.finishSequence).hide()
		$(parent).find("." + this._default.finishSequenceFixedClass).hide();
	},
	/*
	_clearWorkingArea : function(context) {
		var parent = $(context).closest("." + this._default.appContainerClass);
		var actionResultArea = $(parent).find("." + this._default.actionResultContainer);
		$(actionResultArea).html("");
	},*/
	
	_showSelectedPlugin : function(selectedDataCollection,context) {
		var self = this;
		var info = null;
		if (selectedDataCollection) {
			info = this._appMenuHandler._getWorkIdAndFileNameUsingDataCollection(selectedDataCollection);
		}
		var parent = $(context).closest("." + this._default.appContainerClass);
		var method = $(parent).find("." + self._default.selectMethodList).val();
		$container = $(parent).find("." + self._default.actionResultContainer);
		$container.html("Loading...");
		//$(parent).find("." + this._default.applicationOptionClass).hide();
		$(parent).find("." + this._default.nextButtonContainerClass).hide();
		var date = new Date();
		var id = "container_id_" + date.getTime();
		var appOption = $(parent).find("." + self._default.applicationOptionClass + " input[name=applicationOption]:checked").val();
		var fixedSeq = $("#" + self._default.baseSequenceContainerId + " ." + self._default.fixedSequenceClass).html();
		$container.attr("id", id);
		var func = function() {
			self._callback(parent, self);
		}
		var obj = {
			workId : (info) ? info.workId : "",
			fileName : (info) ? info.fileName : "",
			baseSequence : self._baseSequence,
			tooltip : self._tooltip,
			callback : func,
			applicationOption : appOption,
			fixedSequence : fixedSeq,
			motifMethod : this._getSelectedAnalysisMethod(parent),
			dataColl : selectedDataCollection
		};
		/*
		if (method === "MotifExpress") {
			//$(parent).find("." + self._default.applicationOptionClass).show();
			var appOption = $(parent).find("." + self._default.applicationOptionClass + " input[name=applicationOption]:checked").val();
			if (!appOption) {
				appOption = "max";
				$(parent).find("." + self._default.applicationOptionClass + " input[name=applicationOption][value='max']").attr("checked", true);
			}
			obj.applicationOption = appOption;
			$(parent).find("." + self._default.applicationOptionClass).unbind('click');
			$(parent).find("." + self._default.applicationOptionClass).click(function() {
				$(parent).find("." + self._default.nextButtonContainerClass).hide();
				$("#" + id).html("");
				obj.applicationOption = $(this).find("input[name=applicationOption]:checked").val();
				eval(method)(id, obj);
			});
		}*/
		eval(method)(id, obj);
	},
	
	_fillAnalysisMethodCombo : function(selectToolCmbRef) {
		var parent = $(selectToolCmbRef).closest("." + this._default.appContainerClass);
		var selectedTool = $(selectToolCmbRef).val();
		var analysisMethods = this._appMenuHandler._getFilteredDistinctAnalysisMethods(selectedTool);
		var analysisMethodCmb = $(parent).find("." + this._default.analysisMethodComboClass);
		this._fillCombo(analysisMethods, analysisMethodCmb, this._default.analysisMethodComboEmptyOptionText, this._tooltipName.analysisMethod);
	},
	
	_fillExpressionDBCombo : function(analysisMethodCmbRef) {
		var parent = $(analysisMethodCmbRef).closest("." + this._default.appContainerClass);
		var selectedTool = this._getSelectedTool(parent);
		var selectedAnalysisMethod = $(analysisMethodCmbRef).val();
		var expressionDbs = this._appMenuHandler._getFilteredDistinctExpressionDbs(selectedTool,selectedAnalysisMethod);
		var analysisMethodCmb = $(parent).find("." + this._default.expressionDbComboClass);
		this._fillCombo(expressionDbs, analysisMethodCmb, this._default.expressionDbComboEmptyOptionText, this._tooltipName.expressionDb);
	},
	
	_fillDataCollectionCombo : function(expressionDbRef) {
		var parent = $(expressionDbRef).closest("." + this._default.appContainerClass);
		var selectedTool = this._getSelectedTool(parent);
		var selectedAnalysisMethod = this._getSelectedAnalysisMethod(parent);
		var selectedExpressionDb = $(expressionDbRef).val();
		var dataCollections = this._appMenuHandler._getFilteredDistinctDataCollections(selectedTool,selectedAnalysisMethod,selectedExpressionDb);
		var dataColCmb = $(parent).find("." + this._default.dataColomboClass);
		this._fillCombo(dataCollections, dataColCmb, this._default.dataColColomboEmptyOptionText, this._tooltipName.dataCollection);
	},
		
	_fillCombo : function(optionsArr, cmbRef, firstOptionText, firstOptionToolTipKey) {
		$(cmbRef).empty();
		var toolTip = this._tooltip.getByKey(firstOptionToolTipKey);
		$(cmbRef).append("<option value='-1' title='"+ toolTip +"'>"+ firstOptionText +"</option>");
		for (var index = 0 ; index < optionsArr.length ; index++) {
			var option = optionsArr[index];
			toolTip = this._tooltip.getByKey(option);
			$(cmbRef).append("<option value='"+ option + "' title='"+ toolTip +"'>"+ option +"</option>");
		}	
	},

	_fillEmptyBaseSequence : function() {
		var self = this, sb = [];
		for (var i = 0; i < self._default.baseSequenceMaxLength; i++) {
			sb[sb.length] = self.CHAR_SEQ_EMPTY;
		}
		$baseInput = $("#" + this._default.baseSequenceContainerId + " ." + this._default.baseSequenceClass);
		$baseInput.val(sb.join(""));
	},
	
	_loadPluginScriptList : function(workId, fileName, property) {
		var getTripleList = function(tripleList) {
			$.each(tripleList, function(tKey, tVal) {
				LinkDataUtil.loadScript(tVal.object);
			});
		}
		LinkData.getTriplesByProperty(workId, fileName, property, getTripleList);
	},
	
	_changeMethodList : function(dbKey) {
		var self = this;
		var $select = $("." + self._default.appContainerClass + " ." + self._default.selectMethodList);
		$select.attr("title", self._getToolTip(self._tooltipName.selectTool));
		$("option", $select).remove();
		$select.append("<option value='-1' selected='selected'>-- Select Tool --</option>");
		if (dbKey == -1) {
			return;
		}
		var arr = dbKey.split("|");
		var workId = arr[0];
		var fileName = arr[1];
		$.each(self._methodList, function(key, method) {
			self._addValidMethod($select, workId, fileName, method);
		});
	},
	
	_addValidMethod : function($select, workId, fileName, method) {
		var self = this;
		var getFilesByTag = function(fileList) {
			if (!fileList) {
				return;
			}
			$.each(fileList, function(fKey, fName) {
				if (fName === fileName) {
					var tooltip = self._getToolTipByToolName(method);
					tooltip = (tooltip) ? tooltip : "";
					$select.append("<option value='" + method + "' title='" + tooltip + "'>" + method + "</option>");
					return false;
				}
			});
		}
		LinkData.getFilesByTag(workId, method, getFilesByTag);
	},
	
	_initUseButtonListener : function() {
		var self = this;
		$("#" + self._default.baseSequenceContainerId + " ." + self._default.useButtonClass).click(function() {
			self._initDefaultContainer();
			$txtSeq = $("#" + self._default.baseSequenceContainerId + " ." + self._default.baseSequenceClass);
			$fixedSeq = $("#" + self._default.baseSequenceContainerId + " ." + self._default.fixedSequenceClass);
			self._hideError();
			if ($txtSeq.val().length > self._default.baseSequenceMaxLength) {
				self._showError(self._default.errorMessageMaximumSequence.replace("{0}", self._default.baseSequenceMaxLength));
				return;
			}
			if ($txtSeq.val().length < self._default.baseSequenceMaxLength) {
				var tmpVal = $txtSeq.val();
				var eVal = self._getExtraDefaultSequence(self._default.baseSequenceMaxLength - $txtSeq.val().length);
				$txtSeq.val(eVal + tmpVal);
				$("#" + self._default.baseSequenceContainerId + " ." + self._default.baseSequenceClass).attr("size", 500);
			}
			self._baseSequence = $txtSeq.val().toString().toLowerCase() + $fixedSeq.html();
			if (!self._baseSequence || self._baseSequence.length < self._default.baseSequenceMinLength) {
				self._showError(self._default.errorMessageEnterSequence.replace("{0}", self._default.baseSequenceMinLength));
			} else {
				//$txtSeq.attr('readonly', true).addClass("noborder");
				$(this).hide();
				$("." + self._default.appContainerClass).show();
				$("." + self._default.appContainerClass + " ." + self._default.expressionDbContainer).hide();
		    	$("." + self._default.appContainerClass + " ." + self._default.dataColContainer).hide();
				$("." + self._default.appContainerClass + " ." + self._default.analysisMethodContainer).hide();
				$("." + self._default.appContainerClass + " ." + self._default.nextButtonContainerClass).hide();
				$("." + self._default.appContainerClass + " ." + self._default.finishSequence).hide()
			}
		});
	},
	
	_callback : function(parent, self) {
		if (self._isSelectedManualMotif(parent)) {
			$("." + self._default.appContainerClass + " ." + self._default.finishNowButtonClass).hide();
			//self._initNextButtonListener();
		} else {
			$("." + self._default.appContainerClass + " ." + self._default.finishNowButtonClass).show();
			$("." + self._default.appContainerClass + " ." + self._default.finishNowButtonClass).attr("title", self._getToolTip(self._tooltipName.finishNow));
			self._initFinishNowButtonListener();
		}
		$(parent).find("." + self._default.nextButtonContainerClass).show();
		$(parent).find("." + self._default.finishSequence).hide();
		$("." + self._default.appContainerClass + " ." + self._default.nextButtonClass).attr("title", self._getToolTip(self._tooltipName.next));
		$(parent).find("." + self._default.nextButtonContainerClass).show();
		self._initNextButtonListener();
	},
	
	_isSelectedManualMotif : function(parent) {
		var toolCombo = $(parent).find("." + this._default.selectMethodList);
		var selectedTool = toolCombo.val();
		if (selectedTool == this._default.manualMotifEntryToolName) {
			return true;
		} else {
			return false;
		}
	},
	
	_initNextButtonListener : function() {
		var self = this;
		$("." + self._default.appContainerClass + " ." + self._default.nextButtonClass).unbind('click');
		$("." + self._default.appContainerClass + " ." + self._default.nextButtonClass).click(function() {
			$parent = $(this).closest("." + self._default.appContainerClass);
			$parent.find("." + self._default.nextButtonContainerClass).hide();
			$(parent).find("." + self._default.finishSequence).hide()
			var clone = $parent.clone(true);
			$(clone).find("." + self._default.applicationOptionClass).hide();
			var text = $(clone).find(".replaceSequence").text();
			if (text && text.trim().length != 0) {
				self._baseSequence = text;
			}
			$(clone).find("." + self._default.actionResultContainer).html("");
			$(clone).find("." + self._default.nextButtonContainerClass).hide();
			$(clone).find("." + self._default.expressionDbContainer).hide();
		    $(clone).find(" ." + self._default.dataColContainer).hide();
			$(clone).find(" ." + self._default.analysisMethodContainer).hide();
			$parent.parent().append(clone);
		});
	},
	
	_initFinishNowButtonListener : function() {
		var self = this;
		$("." + self._default.appContainerClass + " ." + self._default.finishNowButtonClass).unbind('click');
		$("." + self._default.appContainerClass + " ." + self._default.finishNowButtonClass).click(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$(parent).find("." + self._default.nextButtonContainerClass).hide();
			$(parent).find("." + self._default.finishSequence).hide()
			var gene = $(parent).find(".replaceSequence .gene").val();
			var geneType = $(parent).find(".replaceSequence .geneType").val();
			if (gene && geneType) {
				var callback = function(bSequence) {
					self._showFinishedBaseSequence(parent, bSequence);
				}
				self._appBaseLineSequence.getBaseSequence(gene, geneType, callback);
			} else {
				self._showFinishedBaseSequence(parent,self._baseSequence);
			}
		});
	},
	
	_showFinishedBaseSequence : function(parent, bSequence) {
		var self = this;
		var defaultSequence = $(parent).find(".replaceSequence").text()
		$(parent).find(".wrappedSequenceMotif").hide();	
		var html = self._getFinishedBaseSequence(defaultSequence, bSequence);
		var fixedSequence = self._getFixedSequence();
		$(parent).find("." + self._default.finishSequenceFixedClass).html(fixedSequence);
		$(parent).find("." + self._default.finishSequenceFixedClass).show();
		$(parent).find("." + self._default.finishSequence).show();
		$(parent).find("." + self._default.finishSequence).html(html);
		$(parent).find("." + self._default.finishSequence).scrollLeft(10000);
	},
	
	_getFixedSequence : function() {
		var fixedSequence = $("#" + this._default.baseSequenceContainerId + " ." + this._default.fixedSequenceClass).html();
		return fixedSequence;
	},
	
	_getFinishedBaseSequence : function(defaultSequence, bSequence) {
		var self = this, sb = [];
		var fixedSequence = this._getFixedSequence();
		var uptoFixedSequence = defaultSequence.length - fixedSequence.length;
		for (var i = 0; i < defaultSequence.length; i++) {
			if (i > uptoFixedSequence - 1) {
				continue;
			}
			var dChar = defaultSequence.charAt(i);
			var bChar = bSequence.charAt(i);
			if (bChar) {
				if (dChar !== self.CHAR_SEQ_EMPTY) {
					sb[sb.length] = "<span class='highlight-sequence'><span class='replace'>" + dChar + "</span></span>";
				} else {
					sb[sb.length] = bChar;
				}
			} else {
				sb[sb.length] = "<span class='highlight-sequence'><span class='replace'>" + dChar + "</span></span>";
			}
		}
		return sb.join("");
	},
	
	_getExtraDefaultSequence : function(count) {
		var self = this, sb = [];
		for (var i = 0; i < count; i++) {
			sb[sb.length] = self.CHAR_SEQ_EMPTY;
		}
		return sb.join("");
	},
	
	_getDatabaseOptionKey : function(workId, fileName) {
		return workId + "|" + fileName;
	},
	
	_getLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	_showError : function(message) {
		var self = this;
		$errMsgEl = $("#" + self._default.baseSequenceContainerId + " ." + self._default.baseErrorMessageClass);
		$errMsgEl.html(message);
		$errMsgEl.show();
	},
	
	_hideError : function() {
		var self = this;
		$("#" + self._default.baseSequenceContainerId + " ." + self._default.baseErrorMessageClass).hide();
	},
	
	_getToolTipByFileName : function(fileName) {
		var self = this;
		if (fileName) {
			if (fileName.toLowerCase().indexOf(self._tooltipName.atGeneExpress) > -1) {
				return self._getToolTip(self._tooltipName.atGeneExpress);
			} else if (fileName.toLowerCase().indexOf(self._tooltipName.diunal) > -1) {
				return self._getToolTip(self._tooltipName.diunal);
			}
		}
	},
	
	_getToolTipByToolName : function(tool) {
		var self = this;
		if (tool) {
			if (tool.toLowerCase().indexOf(self._tooltipName.motifExpress) > -1) {
				return self._getToolTip(self._tooltipName.motifExpress);
			} else if (tool.toLowerCase().indexOf(self._tooltipName.motifCircatian) > -1) {
				return self._getToolTip(self._tooltipName.motifCircatian);
			} else if (tool.toLowerCase().indexOf(self._tooltipName.motifRank) > -1) {
				return self._getToolTip(self._tooltipName.motifRank);
			} else if (tool.toLowerCase().indexOf(self._tooltipName.motifQuery) > -1) {
				return self._getToolTip(self._tooltipName.motifQuery);
			} else if (tool.toLowerCase().indexOf(self._tooltipName.inputMotif) > -1) {
				return self._getToolTip(self._tooltipName.inputMotif);
			}
		}
	},
	
	_getToolTip : function(key) {
		return this._tooltip.getByKey(key);
	}
	
};

Application.MenuHandler = function() {
	this._init.apply(this,arguments);
}

Application.MenuHandler.prototype = {
	
	_fullList : [],
	_currentFilteredList : [],
	_workId : null,
	_fileName : null,
	_fileProperties : null,
	
	_properties : {
		motifAnalysisMethod : "motif%20analysis%20method",
		geneExpressionData : "gene%20expression%20data",
		menuDisplayName : "menu%20display%20name",
		toolsList : "tool%20list",
		workIdInTest : "test.linkdata.org",
		workIdPublic : "linkdata.org",
    },
	
	_tags : {
		menuDataSourceTag : "menu"
	},
	
	_defaults : {
		linkdataTestUrl : "test.linkdata.org",
		linkdataPublicUrl : "linkdata.org",
	},
	
	_init : function(args) {
		this._initMenuDataSource();
	},
	
	_fillFileProperties : function() {
		var self = this;
		var setProperties = function(props) {
			self._fileProperties = props;
		};
		LinkData.getProperties(this._workId,this._fileName,setProperties);
	},
	
	_initMenuDataSource : function() {
		var self = this;
		var foundMenuFiles = [];
		var loadMenuFiles = function(resultList) {
			$.each(resultList, function(wId, fileList) {
				$.each(fileList, function(fileKey, fName) {
					var obj = {
						workId : wId,
						fileName : fName
					};
					foundMenuFiles.push(obj);
				});
			});
			self._foundMenuFiles = foundMenuFiles;
			self._loadMenuFileContent(foundMenuFiles);
			self._fillFileProperties();
		};
		LinkData.getFilesByTag(null, this._tags.menuDataSourceTag, loadMenuFiles);
	},
	
	_loadMenuFileContent : function(menuFiles) {
		var self = this;
		var addFileContent = function(triples) {
			for (var index = 0 ; index < triples.length ; index++) {
				self._fullList.push(triples[index]);
			}
			//if (menuFiles.length > 0) {
			//	self._loadMenuFileContent(menuFiles);
			//}
		};
		if (menuFiles.length > 1) {
			alert("There can be only one file that can be tagged with 'menu'");
			return;
		}
		if (menuFiles.length == 0) {
			return;
		}
		var obj = menuFiles.shift(); // removing the first element
		this._fileName = obj.fileName;
		this._workId = obj.workId;
		LinkData.getTriples(this._workId,this._fileName,addFileContent,{start:1, end:2000});
	},
	
	
	_getFilteredAnalysisMethodTriples : function(toolName) {
		if (!(toolName)) return this._fullList;
		this._currentFilteredList = [];
		var listByTool = this._getTriplesByProperty(this._properties.toolsList,this._fullList);
		if (!listByTool) return null;
		var filteredList = [];
		for (var index = 0 ; index < listByTool.length ; index++) {
			var triple = listByTool[index];
			if (triple.object) {
				var toolList = triple.object.split(",");
				for (var index1 = 0 ; index1 < toolList.length ; index1++) {
					var tool = toolList[index1];
					if (tool.trim() == toolName.trim()) {
						var subject = triple.subject;
						var otherPropTripleList = this._getTriplesBySubject(subject);
						for (var index1 = 0 ; index1 < otherPropTripleList.length ; index1++) {
							var propTriple = otherPropTripleList[index1];
							//this._currentFilteredList.push(propTriple);
							filteredList.push(propTriple);
						}
						break;
					}
				}
			}
		}
	    return filteredList;
		/*this._currentFilteredList = filteredList;
		var distinctList = this._getDistinctObjectList(this._properties.motifAnalysisMethod);
		return distinctList;*/
	},
	
	_getFilteredDistinctAnalysisMethods : function(toolName) {
		var filteredList = this._getFilteredAnalysisMethodTriples(toolName);
		this._currentFilteredList = filteredList;
		var distinctList = this._getDistinctObjectList(this._properties.motifAnalysisMethod,filteredList);
		return distinctList;
	},
		
	_getFilteredExpressionDbTriples : function(toolName,analysisMethodName) {
		var listByTool = this._getFilteredAnalysisMethodTriples(toolName);
		var listByAnalysisMethod = this._getTriplesByProperty(this._properties.motifAnalysisMethod,listByTool);
		if (!listByAnalysisMethod) return null;
		var filteredList = [];
		for (var index = 0 ; index < listByAnalysisMethod.length ; index++) {
			var triple = listByAnalysisMethod[index];
			if (triple.object) {
				var analysisMethod = triple.object;
				if (analysisMethod.trim() == analysisMethodName.trim()) {
					var subject = triple.subject;
					var otherPropTripleList = this._getTriplesBySubject(subject);
					for (var index1 = 0 ; index1 < otherPropTripleList.length ; index1++) {
						var propTriple = otherPropTripleList[index1];
						//this._currentFilteredList.push(propTriple);
						filteredList.push(propTriple);
					}
				}
			}
		}
		return filteredList
		/*this._currentFilteredList = filteredList;
		var distinctList = this._getDistinctObjectList(this._properties.geneExpressionData);
		return distinctList;*/
	},
	
	_getFilteredDistinctExpressionDbs : function(toolName,analysisMethodName) {
		var filteredList = this._getFilteredExpressionDbTriples(toolName,analysisMethodName);
		this._currentFilteredList = filteredList;
		var distinctList = this._getDistinctObjectList(this._properties.geneExpressionData,filteredList);
		return distinctList;
	},
		
	_getFilteredDataCollectionTriples : function(toolName,analysisMethodName,expressionDbName) {
		var listByExpDbs = this._getFilteredExpressionDbTriples(toolName,analysisMethodName);
		var listByGeneExp = this._getTriplesByProperty(this._properties.geneExpressionData,listByExpDbs);
		if (!listByGeneExp) return null;
		var filteredList = [];
		for (var index = 0 ; index < listByGeneExp.length ; index++) {
			var triple = listByGeneExp[index];
			if (triple.object) {
				var exprssionDb = triple.object;
				if (exprssionDb.trim() == expressionDbName.trim()) {
					var subject = triple.subject;
					var otherPropTripleList = this._getTriplesBySubject(subject);
					for (var index1 = 0 ; index1 < otherPropTripleList.length ; index1++) {
						var propTriple = otherPropTripleList[index1];
						//this._currentFilteredList.push(propTriple);
						filteredList.push(propTriple);
					}
				}
			}
		}
		return filteredList;
		/*this._currentFilteredList = filteredList;
		var distinctList = this._getDistinctObjectList(this._properties.menuDisplayName);
		return distinctList;*/
	},
		
	_getFilteredDistinctDataCollections : function(toolName,analysisMethodName,expressionDbName) {
		var filteredList = this._getFilteredDataCollectionTriples(toolName,analysisMethodName,expressionDbName);
		this._currentFilteredList = filteredList;
		var distinctList = this._getDistinctObjectList(this._properties.menuDisplayName,filteredList);
		return distinctList;
	},
	
	_getWorkIdAndFileNameUsingDataCollection : function(dataCollectionName) {
		var matchingList = [];
		var outObj = null;
		var listByDataCollection = this._getTriplesByProperty(this._properties.menuDisplayName,this._currentFilteredList);
		if (!listByDataCollection) return null;
		for (var index = 0 ; index < listByDataCollection.length ; index++) {
			var triple = listByDataCollection[index];
			var dataCollection = triple.object;
			if (dataCollection == dataCollectionName) {
				matchingList.push(triple);
			}
		}
		if (matchingList.length > 1) {
			// this a error. because there can be only one matching triple
			alert("Data file error");
		} else {
			// getting other triples for found one
			var subject = matchingList.shift().subject;
			var workId = null;
			var otherPropTripleList = this._getTriplesBySubject(subject);
			var workIdProperty = this._getWorkIdProperty();
			for (var index=0 ; index < otherPropTripleList.length ; index++) {
				var triple = otherPropTripleList[index];
				var prop = this._getProperty(triple.property);
				if (prop == workIdProperty) {
					workId = triple.object;
					break;
				}
			}
			var workIdComps = workId.split("/");
			var subjectComps = subject.split("#");
			outObj = {
				fileName : subjectComps[subjectComps.length-1],
				workId : workIdComps[workIdComps.length-1],
			};
		}
		return outObj;
	},
	
	_getProperty : function(propertyUrl) {
		var comps = propertyUrl.split("#");
		return comps[comps.length-1];
	},
	
	_getWorkIdProperty : function() {
		var hostName = window.location.hostname;
		if (hostName.indexOf(this._defaults.linkdataTestUrl) != -1) {
			return this._properties.workIdInTest;
		} else if (hostName.indexOf(this._defaults.linkdataPublicUrl) != -1) {
			return this._properties.workIdPublic;
		}
	},
	
	_getTriplesByProperty : function(propName,currentList) {
		/*
          this function first will find the triple with the passed property and then
		  this will take the subject of it and will find other properties of that
          subject
		*/
		var filteredList = [];
		//var currentList = this._getCurrentUsingList();
		for (var index = 0 ; index < currentList.length ; index++) {
			var triple = currentList[index];
			var prop = this._getProperty(triple.property);
			if (prop == propName) {
				filteredList.push(triple);
				//var otherPropTripleList = this._getTriplesBySubject(subject);
				//for (var index1 = 0 ; index1 < otherPropTripleList.length ; index1++) {
				//	var propTriple = otherPropTripleList[index1];
				//	filteredList.push(propTriple);
				//}
			}
		}
		return filteredList;
	},
	
	_getTriplesBySubject : function(subject) {
		var filteredList = [];
		var currentList = this._getCurrentUsingList();
		for (var index = 0 ; index < currentList.length ; index++) {
			var triple = currentList[index];
			var triSubject = triple.subject;
			if (triSubject.trim() == subject.trim()) {
				filteredList.push(triple);
			}
			if (filteredList.length == this._fileProperties.length) {
				break;
			}
		}
		return filteredList;
	},
	
	// returns a string array
	_getDistinctObjectList : function(propName,currentList) {
		var distinctList = [];
		for (var index = 0 ; index < currentList.length ; index++) {
			var triple = currentList[index];
			var prop = triple.property;
			if (prop && prop.indexOf(propName) != -1) {
				var objVal = triple.object;
				if (distinctList.indexOf(objVal) == -1) {
					distinctList.push(objVal);
				}
			}
		}
		return distinctList;
	},
	
	_getCurrentUsingList : function() {
		if (this._currentFilteredList.length == 0) {
			return this._fullList;
		} else {
			return this._currentFilteredList;
		}
	},
}
	
Application.baseLineSequence = function() {
	this._init.apply(this, arguments);
};

Application.baseLineSequence.prototype = {
	
	_attedSequenceInfo : null,
	_ppdbSequenceInfo : null,
	
	_default : {
		sequenceProperty : "baseline%20sequence"
	},
	
	_tag : {
		attedBaseSequenceTag : "atted_baseLineSequence",
		ppdbBaseSequenceTag : "ppdb_baseLineSequence"
	},
	
	_init : function() {
		this._attedSequenceInfo = {};
		this._ppdbSequenceInfo = {};
		this._initBaseSequenceFile();
	},
	
	_initBaseSequenceFile : function() {
		this._initAttedBaseSequenceFile();
		this._initPpdbBaseSequenceFile();
	},
	
	_initAttedBaseSequenceFile : function() {
		var self = this;
		var getFilesByTag = function(resultList) {
			$.each(resultList, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._initAttedInfo(workId, fileName);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, self._tag.attedBaseSequenceTag, getFilesByTag);
	},
	
	_initPpdbBaseSequenceFile : function() {
		var self = this;
		var getFilesByTag = function(resultList) {
			$.each(resultList, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._initPpdbInfo(workId, fileName);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, self._tag.ppdbBaseSequenceTag, getFilesByTag);
	},
	
	_initAttedInfo : function(workId, fileName) {
		var self = this;
		var getProperties = function(propertyList) {
			$.each(propertyList, function(pKey, pValue) {
				var propOnly = pValue.split("#")[1];
				if (propOnly == self._default.sequenceProperty) {
					self._attedSequenceInfo.workId = workId;
					self._attedSequenceInfo.fileName = fileName;
					self._attedSequenceInfo.property = pValue;
					return false;
				}
			});
		}
		LinkData.getProperties(workId, fileName, getProperties);
	},
	
	_initPpdbInfo : function(workId, fileName) {
		var self = this;
		var getProperties = function(propertyList) {
			$.each(propertyList, function(pKey, pValue) {
				var propOnly = pValue.split("#")[1];
				if (propOnly == self._default.sequenceProperty) {
					self._ppdbSequenceInfo.workId = workId;
					self._ppdbSequenceInfo.fileName = fileName;
					self._ppdbSequenceInfo.property = pValue;
					return false;
				}
			});
		}
		LinkData.getProperties(workId, fileName, getProperties);
	},
	
	_getAttedSubjectUrl : function(gene) {
		return "http://atted.jp/data/locus/" + gene + ".html";
	},
	
	_getPpdbSubjectUrl : function(gene) {
		return "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene=" + gene;
	},
	
	_getAttedBaseSequence : function(gene, callback) {
		var self = this;
		var workId = self._attedSequenceInfo.workId;
		var fileName = self._attedSequenceInfo.fileName;
		var property = self._attedSequenceInfo.property;
		var subject = self._getAttedSubjectUrl(gene);
		var getObjects = function(objList) {
			callback(objList[0]);
		}
		LinkData.getObjects(workId, fileName, subject, property, getObjects);
	},
	
	_getPpdbBaseSequence : function(gene, callback) {
		var self = this;
		var workId = self._ppdbSequenceInfo.workId;
		var fileName = self._ppdbSequenceInfo.fileName;
		var property = self._ppdbSequenceInfo.property;
		var subject = self._getPpdbSubjectUrl(gene);
		var getObjects = function(objList) {
			callback(objList[0]);
		}
		LinkData.getObjects(workId, fileName, subject, property, getObjects);
	},
	
	getBaseSequence : function(gene, geneType, callback) {
		var self = this;
		if ("ATTED" === geneType) {
			self._getAttedBaseSequence(gene, callback);
		} else if ("PPDB" === geneType) {
			self._getPpdbBaseSequence(gene, callback);
		} else {
			// error
		}
	}
	
};

Application.tooltip = function() {
	this._init.apply(this, arguments);
};

Application.tooltip.prototype = {
	
	_toolTipList : null,
	
	_default : {
		explanationProperty : "explanation"
	},
	
	_init : function() {
		this._toolTipList = [];
		this._initToolTip();
	},
	
	_initToolTip : function() {
		var self = this;
		var getFilesByTag = function(resultList) {
			$.each(resultList, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._getFilePropertyList(workId, fileName);
				});
			});
		}
		LinkData.getFilesByTag(null, "tooltip", getFilesByTag);
	},
	
	_getFilePropertyList : function(workId, fileName) {
		var self = this;
		var index = new Application.index(1, 10000);
		var getProperties = function(propertyList) {
			$.each(propertyList, function(pKey, pValue) {
				if (pValue.indexOf(self._default.explanationProperty) > -1) {
					self._getSubjectList(workId, fileName, pValue, index);
					return false;
				}
			});
		}
		LinkData.getProperties(workId, fileName, getProperties);
	},
	
	_getSubjectList : function(workId, fileName, property, index) {
		var self = this;
		var getSubjects = function(subjectList) {
			self._getPropertyList(subjectList, workId, fileName, property, index);
		}
		LinkData.getSubjects(workId, fileName, getSubjects, index);
	},
	
	_getPropertyList : function(subjectList, workId, fileName, property, index) {
		var self = this;
		var getTriplesByProperty = function(tripleList) {
			self._addToolTipToList(subjectList, tripleList, workId, fileName, property, index);
		}
		LinkData.getTriplesByProperty(workId, fileName, property, getTriplesByProperty, index);
	},
	
	_addToolTipToList : function(subjectList, tripleList, workId, fileName, property, index) {
		var self = this;
		for (var i = 0; i < subjectList.length; i++) {
			var key = self._getLabelAfterHash(subjectList[i]);
			if (tripleList[i]) {
				var value = tripleList[i].object;
				self._addToolTip(key, value);
			}
			//var value = tripleList[i].object;
			//self._addToolTip(key, value);
		}
		if (subjectList && subjectList.length == index.getItemCount()) {
			self._getSubjectList(workId, fileName, property, index.increment());
		}
	},
	
	_addToolTip : function(key, tooltip) {
		var obj = {};
		obj.key = key;
		obj.tooltip = tooltip;
		this._toolTipList.push(obj);
	},
	
	getByKey : function(key) {
		var self = this, tooltip;
		$.each(self._toolTipList, function(objKey, obj) {
			if (obj.key.toString().toLowerCase() === key.toString().toLowerCase()) {
				tooltip = obj.tooltip;
				return false;
			}
		});
		return (tooltip) ? tooltip : "";
	},
	
	_getLabelAfterHash : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	}
	
};

Application.index = function() {
	this._init.apply(this, arguments);
}

Application.index.prototype = {
	
	_start : null,
	_end : null,
	
	_init : function(start, end) {
		this._start = start;
		this._end = end;
	},
	
	getIndex : function() {
		return {start : this._start, end : this._end};
	},
	
	getItemCount : function() {
		return (this._end - this._start + 1);
	},
	
	increment : function() {
		var itemCount = this.getItemCount();
		this._start = this._start + itemCount;
		this._end = this._end + itemCount;
		return {start : this._start, end : this._end};
	},
	
	getStartIndex : function() {
		return this._start;
	},
	
	getEndIndex : function() {
		return this._end;
	}
	
};

Application.timer = function() {
	this._init.apply(this, arguments);
};

Application.timer.prototype = {
	
	_delay : null,
	_retry : null,
	_maxRetry : null,
	
	_init : function() {
		this._delay = 1000;
		this._retry = 0;
		this._maxRetry = 100;
	},
	
	call : function(func) {
		if (this._retry < this._maxRetry) {
			setTimeout(func, this._delay);
		}
		this._retry++;
	},
	
	setMaxRetryCount : function(no) {
		this._maxRetry = no;
	}
};

Application.MotifConflication = function() {
	this._init.apply(this, arguments);
};

function _deleteUserSequence(sequence,containerId,comp) {
	var userSequenceArea = null;
	//var t = new Application.sequence();
	//t._deleteUserSequence(sequence);
	$("#" + containerId + " .resultArea .userSequence").each(function() {
		var seq = $(this).find(".hdnSequence").val();
		if (seq == sequence) {
			userSequenceArea = this;
			return false;
		}
	});
	if (userSequenceArea) {
		$("#" + containerId + " .resultArea ." + sequence).remove();
		$(userSequenceArea).parent().remove();	
	}
}

/*
Application.MotifConflication.prototype = {
	
	_motifConflictConfirmDialogId : null,
	_containerId : null,
	_resultAreaClass : "resultArea",
	_baseSequenceLength : 550,
	_baseSequence : null,
	_appSequence : null,
	replaceSequenceClass : "replaceSequence",
	htmlRenderFunction : null,
	htmlSetFunctionOwner : null,
	
	defaults : {
		conflictionDialogTitle : "Confliction",	
	},
	
	_init : function(para,appSequnce) {
		//this._containerId = para;
		this._containerId = para;
		//this._resultAreaClass = para.resutAreaClass;
		//this._baseSequenceLength = para.baseSequenceLength;
		//this._appSequence = appSequnce; 
	},
	
	_setAppSequnce : function(appSequence) {
		this._appSequence = appSequence;	
	},
	
	_setHtmlSetFunction  : function(func) {
		this.htmlRenderFunction = func;
	},
	
	_setHtmlSetFunctionOwner : function(owner) {
		this.htmlSetFunctionOwner = owner;
	},
	
	_initConflictConfirmDialogView : function() {
		var sb = [], date = new Date(); 
		//self._motifConflictConfirmDialogId = "motifConflictConfirmDialog_id_" + self._containerId + "_" + date.getTime();
		this._motifConflictConfirmDialogId = "motifConflictConfirmDialog_id_" + date.getTime();
		sb[sb.length] = "<div id='" + this._motifConflictConfirmDialogId + "' class='hidden' style='width:200px'>";
		sb[sb.length] = "<div>New motif overlaps with old one. Which one should be kept in overalp regions?</div>";
		sb[sb.length] = "<div class='option'>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='new'/>&nbsp;New</label></div>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='old'/>&nbsp;Old</label></div>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='discard'/>&nbsp;Discard new motif</label></div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<label><input type='checkbox' checked=checked class='motifReplaceApplyToAllMotifMax' value='applytoall'/>&nbsp;Apply to all</label>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
		console.log(this._containerId);
	},
	
	_initMotifConflictConfirmDialog : function() {
		var self = this;
		$("#" + self._motifConflictConfirmDialogId).dialog({
			autoOpen: false,
			width: 420,
			dialogClass : "motifConflictionDialog"
		});
	},
	
	_handleConfliction : function(conflictArray) {
		var self = this;
		if (conflictArray.length > 0) {
			var arr = conflictArray[0].split("|");
			var bArray = self._getConflictConfirmDialogButtonArray(conflictArray);
			var dialogTitle =  this.defaults.conflictionDialogTitle + " - " +  arr[0] + "[" + arr[1] + "]";
			$("#" + self._motifConflictConfirmDialogId).find("input[name='motifReplaceOption'][value='new']").attr("checked", "checked");
			var checkBox = $("#" + self._motifConflictConfirmDialogId).find("input[class='motifReplaceApplyToAllMotifMax']");
			$(checkBox).attr("checked",$(checkBox).is(':checked'));
			//$("#" + self._motifConflictConfirmDialogId).find(".motifReplaceApplyToAll").attr("checked", "checked");
			$("#" + self._motifConflictConfirmDialogId).dialog({title : dialogTitle});
			$("#" + self._motifConflictConfirmDialogId).dialog({buttons : bArray});
			$("#" + self._motifConflictConfirmDialogId).dialog("open");
		} else {
			$("#" + self._motifConflictConfirmDialogId).find("input[class='motifReplaceApplyToAllMotifMax']").attr("checked", "checked");	
		}
	},
	
	_getConflictConfirmDialogButtonArray : function(conflictArray) {
		var self = this;
		return [
				{
					text: "Done",
					click : function() {
						$(this).dialog("close");
						var option = $(this).find("input[name='motifReplaceOption']:checked").val();
						var isApplyToAll = $(this).find(".motifReplaceApplyToAll").is(":checked");
						self._replaceWithOption(option, isApplyToAll, conflictArray);
					}
				},
				{
					text: "Cancel",
					click : function() {
						$(this).dialog("close");
					}
				}
			];
	},
	
	_replaceWithOption : function(option, isApplyToAll, conflictArray) {
		var self = this;
		if (isApplyToAll) {
			self._replaceAllWithOption(option, conflictArray);
			$("#" + self._motifConflictConfirmDialogId).find(".motifReplaceApplyToAll").attr("checked", "checked");
		} else {
			var value = conflictArray.splice(0, 1);
			var arr = value[0].split("|");
			self._replaceSequenceByOption(option, arr[0], arr[1]);
			self._handleConfliction(conflictArray);
		}
	},
	
	_replaceAllWithOption : function(option, conflictArray) {
		var self = this, html = oldSequence;
		var oldSequence = $("#" + self._containerId + " ." + self.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self.resultAreaClass + " .baseSequence").html();
		}
		$.each(conflictArray, function(key, conflict) {
			var arr = conflict.split("|");
			self._replaceSequenceByOption(option, arr[0], arr[1]);
		});
	},
	
	_replaceSequenceByOption : function(option, seq, pos) {
		var self = this;
		var oldSequence = $("#" + self._containerId + " ." + self.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self.resultAreaClass + " .baseSequence").html();
		}
		var formattedSeq = self._appSequence.getFormattedSequence(self._baseSequenceLength, seq, pos);
		var seqArray = [formattedSeq];
		var newSequence = self._appSequence._getMergeCharSequence(seqArray);
		var html = oldSequence;
		if (option === "new") {
			html = self._appSequence.getHtmlByReplacingNewSequence(oldSequence, newSequence);
		} else if (option === "old") {
			html = self._appSequence.getHtmlByReplacingOldSequence(oldSequence, newSequence);
		}
		//self._doReplaceWithHtml(html);
		self.htmlRenderFunction.call(html);
	},
	
	_hasConfliction : function(seq, pos, oldSequence) {
		var self = this;
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self._resultAreaClass + " .baseSequence").html();
		}
		var formattedSeq = self._appSequence.getFormattedSequence(self._baseSequenceLength, seq, pos);
		var array = [formattedSeq];
		var newSequence = self._appSequence._getMergeCharSequence(array);
		for (var i = 0; i < oldSequence.length; i++) {
			var oChar = oldSequence.charAt(i);
			var nChar = newSequence.charAt(i);
			if (nChar !== "-" && oChar !== "-" && nChar !== oChar) {
				return true;
			}
		}
		return false;
	},
}
*/
$(document).ready(function() {
	new Application.genocon();
});
