/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/

/*
 * 定数
 */

// カテゴリ
var C_CATEGORY1 = '常住地';
var C_CATEGORY2 = '就業地・通学地';

var C_ORIGIN    = 'origin';				// 常住地
var C_DESTIN    = 'destination';			// 就業地・通学地

// 利用交通手段
var C_WAY1CNT  = '総数（利用交通手段）';
var C_WAY2CNT  = '徒歩だけ';
var C_WAY3CNT  = '鉄道・電車';
var C_WAY4CNT  = '乗合バス';
var C_WAY5CNT  = '勤め先・学校のバス';
var C_WAY6CNT  = '自家用車';
var C_WAY7CNT  = 'ハイヤー・タクシー';
var C_WAY8CNT  = 'オートバイ';
var C_WAY9CNT  = '自転車';
var C_WAY10CNT = 'その他';
var C_WAY11CNT = '鉄道・電車及び乗合バス';
var C_WAY12CNT = '鉄道・電車及び勤め先・学校のバス';
var C_WAY13CNT = '鉄道・電車及び自家用車';
var C_WAY14CNT = '鉄道・電車及びオートバイ';
var C_WAY15CNT = '鉄道・電車及び自転車';
var C_WAY16CNT = 'その他利用交通手段が2種類';
var C_WAY17CNT = '利用交通手段が3種類以上';
var C_WAY0CNT  = '不詳';

/*
 * 変数
 */

// 表示するデータの分類（デフォルトは「常駐地」）
var selCategory = '常住地';

// 基本となる場所（デフォルトは「東京都」）
var selArea = '東京都';

/**
 * 事前処理
 */

// パッケージのロード
google.load('visualization', '1', {'packages': ['geochart', 'corechart']});
google.setOnLoadCallback(initialize);

// データセット格納テーブル
var lowdata;

// iPhone、iPadなど対応
$("#startgraph").on('tap', function(){
	setCategory();
	setArea();
	drawVisualization();
})

/**
 * カテゴリの取得
 */
function setCategory(){
	selCategory = $("#category")[0].value;
	if (selCategory == C_CATEGORY1){
		$('#placed').html(C_CATEGORY2);
	} else {
		$('#placed').html(C_CATEGORY1);

	}

}

/**
 * 常駐地または就業地・通学地の取得
 */
function setArea(){
	selArea = $("#area")[0].value;

}

/**
 * 都道府県名称から「都」「府」「県」を削除する
 */
function setPrefForPlot(target){
	retValue = target.replace('都', '');
	retValue = retValue.replace('府', '');
	retValue = retValue.replace('県', '');
	if (target == '京都府') retValue = '京都';
	return retValue;
}


/**
 * ロード時処理・データセットからデータを取得する
 */
function initialize(){

	var limit = 19;
	var count = 0;

	// データセット格納テーブルの作成
	lowdata = new google.visualization.DataTable();
	lowdata.addColumn('string','cityo');
	lowdata.addColumn('string','cityd');
	lowdata.addColumn('number',C_WAY1CNT);
	lowdata.addColumn('number',C_WAY2CNT);
	lowdata.addColumn('number',C_WAY3CNT);
	lowdata.addColumn('number',C_WAY4CNT);
	lowdata.addColumn('number',C_WAY5CNT);
	lowdata.addColumn('number',C_WAY6CNT);
	lowdata.addColumn('number',C_WAY7CNT);
	lowdata.addColumn('number',C_WAY8CNT);
	lowdata.addColumn('number',C_WAY9CNT);
	lowdata.addColumn('number',C_WAY10CNT);
	lowdata.addColumn('number',C_WAY11CNT);
	lowdata.addColumn('number',C_WAY12CNT);
	lowdata.addColumn('number',C_WAY13CNT);
	lowdata.addColumn('number',C_WAY14CNT);
	lowdata.addColumn('number',C_WAY15CNT);
	lowdata.addColumn('number',C_WAY16CNT);
	lowdata.addColumn('number',C_WAY17CNT);
	lowdata.addColumn('number',C_WAY0CNT);		// その他（データセットにはない）

	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				count = 0;
				arySource = new Array();
				arySourceBy = new Array();

				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					if(count++ > limit) {
						return false;
					}

					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						testProp = propValue.replace('http://dbpedia.org/ontology/', '');
						testProp = decodeURI(testProp.replace('http://linkdata.org/property/rdf1s1113i#', ''));
						testValue = objValue.replace('http://ja.wikipedia.org/wiki/', '');
						arySource[testProp] = testValue;

					});

				});

				// 数値データの型変換
				vWay1Cnt = Number(arySource[C_WAY1CNT]);
				vWay2Cnt = Number(arySource[C_WAY2CNT]);
				vWay3Cnt = Number(arySource[C_WAY3CNT]);
				vWay4Cnt = Number(arySource[C_WAY4CNT]);
				vWay5Cnt = Number(arySource[C_WAY5CNT]);
				vWay6Cnt = Number(arySource[C_WAY6CNT]);
				vWay7Cnt = Number(arySource[C_WAY7CNT]);
				vWay8Cnt = Number(arySource[C_WAY8CNT]);
				vWay9Cnt = Number(arySource[C_WAY9CNT]);
				vWay10Cnt = Number(arySource[C_WAY10CNT]);
				vWay11Cnt = Number(arySource[C_WAY11CNT]);
				vWay12Cnt = Number(arySource[C_WAY12CNT]);
				vWay13Cnt = Number(arySource[C_WAY13CNT]);
				vWay14Cnt = Number(arySource[C_WAY14CNT]);
				vWay15Cnt = Number(arySource[C_WAY15CNT]);
				vWay16Cnt = Number(arySource[C_WAY16CNT]);
				vWay17Cnt = Number(arySource[C_WAY17CNT]);
				vWay0Cnt = vWay1Cnt - vWay2Cnt - vWay3Cnt - vWay4Cnt - vWay5Cnt - vWay6Cnt - vWay7Cnt
							- vWay8Cnt - vWay9Cnt - vWay10Cnt - vWay11Cnt - vWay12Cnt - vWay13Cnt - vWay14Cnt
							 - vWay15Cnt - vWay16Cnt - vWay17Cnt;
							    
//				alert(arySource[C_ORIGIN]);
				// データの追加
				lowdata.addRow([
						setPrefForPlot(arySource[C_ORIGIN]),
						setPrefForPlot(arySource[C_DESTIN]),
						vWay1Cnt,
						vWay2Cnt,
						vWay3Cnt,
						vWay4Cnt,
						vWay5Cnt,
						vWay6Cnt,
						vWay7Cnt,
						vWay8Cnt,
						vWay9Cnt,
						vWay10Cnt,
						vWay11Cnt,
						vWay12Cnt,
						vWay13Cnt,
						vWay14Cnt,
						vWay15Cnt,
						vWay16Cnt,
						vWay17Cnt,
						vWay0Cnt
				]);

			});
		});
	});
	
//	alert(lowdata.getFilteredRows([{column: 1, value: '東京'}])[0]);

	// geochartグラフの描画
	drawVisualization();

}

/**
 * geochartグラフの描画
 */
function drawVisualization() {

	// 格納データ検索キー
	var key;
	var icol;
	var icol1;
	// プロットデータ格納テーブル
	var tabdata = new google.visualization.DataTable();	// geochart用
	var wrkdata = new google.visualization.DataTable();	// 作業用

	var dumdata = new google.visualization.DataTable();	// 初期表示用
	dumdata.addColumn('string','利用交通手段');
	dumdata.addColumn('number','就業者数または通学者数');
	var pie = new google.visualization.PieChart(document.getElementById('piechartarea'));
	pie.draw(dumdata);

	// テーブルデータ構造定義
	tabdata.addColumn('string','city');
	tabdata.addColumn('number','就業者数または通学者数');

	// messageを表示する
	$("#message").css("display", "block");

	// キーの設定
	key = setPrefForPlot(selArea);
	if (C_CATEGORY1 == selCategory){
		icol = 0;
		icol1 = 1;

	} else {
		icol = 1;
		icol1 = 0;

	}

	// マッチするデータ行インデックスを取得
	var intRow = lowdata.getFilteredRows([{column: icol, value: key}]);
//	alert(key + ' found ' + intRow.length + ' rows');
	// テーブルデータ構造定義
	wrkdata.addColumn('string','city');
	wrkdata.addColumn('number',C_WAY2CNT);
	wrkdata.addColumn('number',C_WAY3CNT);
	wrkdata.addColumn('number',C_WAY4CNT);
	wrkdata.addColumn('number',C_WAY5CNT);
	wrkdata.addColumn('number',C_WAY6CNT);
	wrkdata.addColumn('number',C_WAY7CNT);
	wrkdata.addColumn('number',C_WAY8CNT);
	wrkdata.addColumn('number',C_WAY9CNT);
	wrkdata.addColumn('number',C_WAY10CNT);
	wrkdata.addColumn('number',C_WAY11CNT);
	wrkdata.addColumn('number',C_WAY12CNT);
	wrkdata.addColumn('number',C_WAY13CNT);
	wrkdata.addColumn('number',C_WAY14CNT);
	wrkdata.addColumn('number',C_WAY15CNT);
	wrkdata.addColumn('number',C_WAY16CNT);
	wrkdata.addColumn('number',C_WAY17CNT);
	wrkdata.addColumn('number',C_WAY0CNT);


	// 検索結果データをgeochartプロット格納テーブル、作業用テーブルに追加
	for (var idx in intRow){
// alert(lowdata.getValue(intRow[idx], icol1));
		tabdata.addRow([
			lowdata.getValue(intRow[idx], icol1),
			lowdata.getValue(intRow[idx], 2)
		]);

		wrkdata.addRow([
			lowdata.getValue(intRow[idx], icol1),
			lowdata.getValue(intRow[idx], 3),
			lowdata.getValue(intRow[idx], 4),
			lowdata.getValue(intRow[idx], 5),
			lowdata.getValue(intRow[idx], 6),
			lowdata.getValue(intRow[idx], 7),
			lowdata.getValue(intRow[idx], 8),
			lowdata.getValue(intRow[idx], 9),
			lowdata.getValue(intRow[idx], 10),
			lowdata.getValue(intRow[idx], 11),
			lowdata.getValue(intRow[idx], 12),
			lowdata.getValue(intRow[idx], 13),
			lowdata.getValue(intRow[idx], 14),
			lowdata.getValue(intRow[idx], 15),
			lowdata.getValue(intRow[idx], 16),
			lowdata.getValue(intRow[idx], 17),
			lowdata.getValue(intRow[idx], 18),
			lowdata.getValue(intRow[idx], 19)
		]);
		
	}

	// 描画オプション
	var options = {
		region:'JP',
		resolution:'provinces'
	};

	// messageを非表示にする
	$("#message").css("display", "none");

	var chart = new google.visualization.GeoChart(document.getElementById('visualization'));
	chart.draw(tabdata, options);

	/*
	 * 場所選択時イベント
	 */
	google.visualization.events.addListener(chart, 'select', function() {
		
		// 選択した場所を取得
		var row = chart.getSelection()[0].row;
		var key = tabdata.getValue(row, 0);
//		alert('You selected ' + key);

		var piedata = new google.visualization.DataTable();	// piechart用
		piedata.addColumn('string','利用交通手段');
		piedata.addColumn('number','就業者数または通学者数');
		
		var intRow = wrkdata.getFilteredRows([{column: 0, value: key}])[0];
//		alert(intRow + ':' + wrkdata.getValue(intRow, 0));
		piedata.addRow([C_WAY2CNT, wrkdata.getValue(intRow, 1)]);
		piedata.addRow([C_WAY3CNT, wrkdata.getValue(intRow, 2)]);
		piedata.addRow([C_WAY4CNT, wrkdata.getValue(intRow, 3)]);
		piedata.addRow([C_WAY5CNT, wrkdata.getValue(intRow, 4)]);
		piedata.addRow([C_WAY6CNT, wrkdata.getValue(intRow, 5)]);
		piedata.addRow([C_WAY7CNT, wrkdata.getValue(intRow, 6)]);
		piedata.addRow([C_WAY8CNT, wrkdata.getValue(intRow, 7)]);
		piedata.addRow([C_WAY9CNT, wrkdata.getValue(intRow, 8)]);
		piedata.addRow([C_WAY10CNT, wrkdata.getValue(intRow, 9)]);
		piedata.addRow([C_WAY11CNT, wrkdata.getValue(intRow, 10)]);
		piedata.addRow([C_WAY12CNT, wrkdata.getValue(intRow, 11)]);
		piedata.addRow([C_WAY13CNT, wrkdata.getValue(intRow, 12)]);
		piedata.addRow([C_WAY14CNT, wrkdata.getValue(intRow, 13)]);
		piedata.addRow([C_WAY15CNT, wrkdata.getValue(intRow, 14)]);
		piedata.addRow([C_WAY16CNT, wrkdata.getValue(intRow, 15)]);
		piedata.addRow([C_WAY17CNT, wrkdata.getValue(intRow, 16)]);
		piedata.addRow([C_WAY0CNT, wrkdata.getValue(intRow, 17)]);

		// 描画オプション
		// 描画オプション
		if (key == setPrefForPlot(selArea)){
			var vTitle = key + '内の移動交通手段';

		} else {
			var vTitle = key + ' ー ' + setPrefForPlot(selArea) + '間の移動交通手段';

		}
		var pieoptions = {
			title:vTitle,
			backgroundColor:'#CCFFFF'
		};

		pie.draw(piedata,pieoptions);

	});

/*
 */

}
