$(window).load(function() {

	sparql = new Sparql();
 	
	//SPARQL検索の実行
	$('#find_query').click(function(){
		//sparql.findByQuery($('#query_area').val().replace(/[\n\r]/g,""));
		//使用するSPARQLクエリの設定
		query = 'PREFIX lodosaka:<http://lodosaka.hozo.jp/>\n'+
				'SELECT ?ku (COUNT(?uri) AS ?count)  WHERE{\n'+
				'   ?uri lodosaka:category_1 ?cat;\n'+
				'      lodosaka:ku ?ku.\n'+
				'  FILTER regex(str(?cat), "^(名所・旧跡)|(文化・観光)$")\n'+
				'}GROUP BY ?ku\n'+
				'ORDER BY DESC(?count)\n'
		//結果を表示する欄の設定
		sparql.result_div = $('#result_div');
		//クエリの実行
		sparql.findByQuery(query);
	});
	
/*	//SPAQRLエンドポイントの切り替え
	$('#change_endpoint').click(function(){
		init();
	});*/

	$('#result_div').hide();

	init();
});


function init(){
	// Servletサーバアドレス
	sparql.server = "http://lod.hozo.jp";

	// 検索対象エンドポイント（途中での改行は不可）
 	//var endpoint = $('#endpoint_url').val();
	sparql.endpoint = {"endpoint": "http://lod.hozo.jp/repositories/OsakaCityMap", "namespaces": ""};
	sparql.init();
	
	//結果表示処理を行う関数を指定
//	sparql.result_func = result_table;
	sparql.result_func = bar_chart;
	
}


//結果表示の関数（棒グラフ）
function bar_chart(data){
	var result_div = $('#result_div');
	var arry = new Array();
	//SPARQLクエリの結果（JSON形式）から，表示用データを作る
	//利用しているグラフライブラリでは，labelに項目，dataにその項目のデータを入れる
	for (var i=0; i<data.length; i++){
		arry.push({'label':data[i].ku, data:[[i, data[i].count]]});
		}
	
	$('#result_div').show();
	$.plot('#result_div', arry, {
	    series: {
	        bars: {
	            show: true,
	        }
	    },
	});
	
}

//結果表示用の関数（テーブル表示）
//「ひな形」で用意しているデフォルト表示★この例では使っていない
function result_table(data){
	 var result_div = $('#result_div');

	var table = $('#result_list')[0];


	if (table == undefined) {
		result_div.append($('<table border="1"></table>').attr({
			'id' : 'result_list',
			'class' : 'table'
		}));
		table = $('#result_list')[0];
	}

	while (table.rows.length > 0) {
		table.deleteRow(0); // 行を追加
	}

	if (data instanceof Array) {
		result_div.show();
		// ヘッダ
		var header = table.createTHead(); // 行を追加
		var headerRow = header.insertRow(0);

		id = 1;
		for (var d = 0; d < data.length; d++) {
			var row1 = table.insertRow(d + 1); // 行を追加

			if (d == 0) {
				for ( var key in data[0]) {
					var th = document.createElement('th');
					var label = key;
					th.innerHTML = key;
					headerRow.appendChild(th);
				}
			}
	
			var i = 0;
			// ID
			for ( var key in data[d]) {
				var cell = row1.insertCell(i++); // ２つ目以降のセルを追加
				var value = data[d][key];
				if (value.uri != undefined){
					value = value.uri;
				}
				if (value == null) {
					value = '';
				}
	
				var link = true;
				if (link) {
					if (value != null && value.indexOf("http://") == 0) {
						value = '<a href="'+value+'" target="_blank">'
								+ value + '</a>';
					}
				}
				cell.innerHTML = value;
			}
		}
	}
};
