if(typeof LINKDATA==="undefined" || !LINKDATA){var LINKDATA = {};}

LINKDATA = function() {
	"use strict";
	this._init.apply(this, arguments);
};

LINKDATA.prototype = {
	_msg : "NONE",
	_locations : [],
	_imgNegative : "http://maps.google.co.jp/mapfiles/ms/icons/blue-dot.png",
	_imgPositive : "http://maps.google.co.jp/mapfiles/ms/icons/red-dot.png",


	_init : function() {
		"use strict";
		this._msg = "";
	},
	
	setMarkers : function(map, locations) {
		"use strict";
		var i = 0;
		var infoWindow = new google.maps.InfoWindow();
		for (i = 0; i < locations.length; i++) {
			var location = locations[i];
			this.setMarker(map, infoWindow, location);
		}
	},
	// heapmap用に追加
	setHeatmap : function(map, locations) {
		"use strict";
		var dengueData = new Array();
		for(var i=0;i<locations.length;i++){
			if(locations[i][4]=="陽性"){
				dengueData.push(new google.maps.LatLng(locations[i][1],locations[i][2]));
			}
		}

		var pointArray = new google.maps.MVCArray(dengueData);
 		var heatmap = new google.maps.visualization.HeatmapLayer({
			data: pointArray,
			radius: 30
		});
		heatmap.setMap(map);
	},
	setMarker : function(map, infoWindow, location) {
		var name = location[0];
		var mosquito = location[3];
		var pcr = location[4];
		
		var marker_img;
		if(pcr=="陽性"){
			marker_img=this._imgPositive;
		}else{
			marker_img=this._imgNegative;
		}

		var latLng = new google.maps.LatLng(location[1], location[2]);
		var marker = new google.maps.Marker({
			position: latLng,
			map: map,
			title: name,
			icon: marker_img,
			zIndex: 4
		});
		var sb = [];
		sb[sb.length] = '<div class="balloon">';
		sb[sb.length] = '  <div class="title">' + name + '</div>';
		sb[sb.length] = '  <div class="spot">';
		sb[sb.length] = '   <table>';
		if (mosquito) {
			sb[sb.length] = '    <tr><td>採集した蚊の数:</td><td>' + mosquito + '</td></tr>';
		}
		if (pcr) {
			sb[sb.length] = '    <tr><td>PCR検査結果:</td><td>' + pcr + '</td></tr>';
		}
		sb[sb.length] = '   </table">';
		sb[sb.length] = '  </div>';
		sb[sb.length] = '</div>';
		google.maps.event.addListener(marker, 'click', function() {
			infoWindow.setContent(sb.join("")); 
			infoWindow.open(map, marker); 
		});
	},
	popup : function() {
		"use strict";
		alert(this._msg);
	},
	getLocations : function() {
		"use strict";
		return this._locations;
	},

	googleMapInitialize : function(locations) {
		"use strict";
		var startLatlng = new google.maps.LatLng(
								35.67173763421201,139.69494469999995);
		var myOptions = {
			center: startLatlng,
			zoom: 14,
			mapTypeId: google.maps.MapTypeId.ROADMAP
		};
		var map = new google.maps.Map(
			document.getElementById("map_canvas"), myOptions);
		
		// heapmap用に追加
		this.setHeatmap(map, locations);		
		//this.setMarkers(map, locations);
	},
	
	dataload : function() {
		"use strict";
		var works = LINKDATA.getWorkIds();
		var self = this;
		$.each(works, function(workKey, workValue) {
			$.each(LINKDATA.getFiles(workValue), function(workId, fileName) {
				$.each(LINKDATA.getFiles(workValue), function(fileKey, fileValue) {
					$.each(LINKDATA.getSubjects(workValue, fileValue), function(subjKey, subjValue) {						
						var name = "";
						var mosquito = 0;
						var pcr = 0;
						var lat = 0;
						var long = 0;

						$.each(LINKDATA.getProperties(workValue, fileValue), function(propKey, propValue) {
							$.each(LINKDATA.getObjects(workValue, fileValue, subjValue, propValue.url), function(objKey, objValue) {
								if (propValue.label === "label") {
									name = objValue;
								} else if (propValue.label === "採集した蚊の数" ) {
									mosquito = objValue;
								} else if (propValue.label === "PCR検査結果" ) {
									pcr = objValue;
								} else if (propValue.label === "lat" ) {
									lat = objValue;
								} else if (propValue.label === "long" ) {
									long = objValue;
								/*
								} else {
									；
								*/
								}
							});
						});
						self._locations.push([name, lat, long, mosquito, pcr]);
					});
				});
			});
		});
	}
};
LINKDATA.getWorkIds = function() {
	"use strict";
	return LinkData.getWorks();
};
LINKDATA.getFiles = function(workId) {
	"use strict";
	return LinkData.getFiles(workId);
};
LINKDATA.getSubjects = function(workId, fileName) {
	"use strict";
	return LinkData.getSubjects(workId, fileName);
};
LINKDATA.getProperties = function(workId, fileName) {
	"use strict";
	var result = [];
    $.each(LinkData.getProperties(workId, fileName), function(key, value) {
        var arr = value.split("#");
        if (arr.length > 1) {
            result.push({"url" : value, "label" : decodeURIComponent(arr[1])})
        }
    });
    return result;
};
LINKDATA.getObjects = function(workId, fileName, subject, property) {
	"use strict";
	return LinkData.getObjects(workId, fileName, subject, property);
};

init = function() {
	"use strict";
	var t = new LINKDATA();
	t.dataload();
	t.googleMapInitialize(t.getLocations());
};

window.onload = function() {
	"use strict";
	init();
};
