/*
1. LinkData.getSubjectsについて
　先頭から1万ちょっとまでしか取得できないっぽい
　ファイルを分割して対処
2. LinkData.getObjectsについて
　たまに500エラーで落ちる事がある（そうなるとコールバック関数は実行されない）
　エラートラップの仕方が分からんのでDeferredに頼らずデータが格納されたかどうかで成否を判別する
*/

var rdf = {};
var formats = {};
var data = {};

function getWorksDeferred() {
//LinkData.getWorksをDeferred化しただけ
	var d = $.Deferred();
	LinkData.getWorks(function(res) {
		$.each(res, function(key, workId) {
			rdf.works[workId] = {};
		});
		d.resolve();
	});
	return d.promise();
}

function getFilesDeferred(workId) {
//LinkData.getFilesをDeferred化しただけ
	var d = $.Deferred();
	LinkData.getFiles(workId, function(res) {
		$.each(res, function(fileKey, fileName) {
			rdf.works[workId][fileName] = { "loaded":false, "subjects":[] };
		});
		d.resolve();
	});
	return d.promise();
}

function getSubjectsDeferred(workId, fileName) {
//LinkData.getSubjectsをDeferred化しただけ
	var d = $.Deferred();
	LinkData.getSubjects(workId, fileName, function(res) {
		$.each(res, function(subjectKey, subjectValue) {
			rdf.works[workId][fileName].subjects.push(subjectValue.substr(-17));
		});
		rdf.works[workId][fileName].loaded = true;
		d.resolve();
	});
	return d.promise();
}

function getRdfFormat() {
//入力データに指定されている全てのワーク・ファイル・サブジェクトを取得
	var d = $.Deferred();
	rdf.works = {};
	var deferreds = [];
	deferreds.push(getWorksDeferred());
	$.when.apply($, deferreds).done(function() {
		deferreds = [];
		for (var work in rdf.works) {
			deferreds.push(getFilesDeferred(work));
		}
		$.when.apply($, deferreds).done(function() {
			//本オブジェクトのresolveはファイル名までの取得が終わった事のみ保証する
			//サブジェクトの取得完了についてはrdf.works[work][file].loadedで判断
			d.resolve();
			var reverseLookup = {}; //ファイル名からワーク名を逆引きするためのオブジェクト
			var files = []; //ソート用のファイル名配列
			for (var work in rdf.works) {
				for (var file in rdf.works[work]) {
					reverseLookup[file] = work;
					files.push(file);
				}
			}
			//年月の下限・上限を求めるためにまず名前順で最初と最後のファイルについてサブジェクトを問い合わせる
			files.sort();
			rdf.first = [files[0]];//最初のファイル名
			rdf.first.push(reverseLookup[rdf.first[0]]);//最初のファイルのワーク名
			getSubjectsDeferred(rdf.first[1], rdf.first[0]);
			rdf.last = [files[files.length - 1]];//最後のファイル名
			rdf.last.push(reverseLookup[rdf.last[0]]);//最後のファイルのワーク名
			getSubjectsDeferred(rdf.last[1], rdf.last[0]);
			//残りはその後に、新しい方から
			for (var i = files.length - 2; i > 0; i--) {
				getSubjectsDeferred(reverseLookup[files[i]], files[i]);
			}
		});
	});
	return d.promise();
}

function waitLimitGot() {
//名前順で最初と最後のファイルのサブジェクトが取得されるのを待って年月の下限・上限を調べる
	$("#info").empty().append("設定ロード中…");
	var d = $.Deferred();
	if (typeof rdf.minMonth === "undefined" || typeof rdf.maxMonth === "undefined") {
		var timerId = setInterval(function() {
			if (rdf.works[rdf.first[1]][rdf.first[0]].loaded &&
				rdf.works[rdf.last[1]][rdf.last[0]].loaded) {
				rdf.minMonth = "201001";
				for (var i = 0; i < rdf.works[rdf.first[1]][rdf.first[0]].subjects.length; i++) {
					if (rdf.minMonth > rdf.works[rdf.first[1]][rdf.first[0]].subjects[i].substr(-7, 6)) {
						rdf.minMonth = rdf.works[rdf.first[1]][rdf.first[0]].subjects[i].substr(-7, 6);
					}
				}
				rdf.maxMonth = "201001";
				for (var i = 0; i < rdf.works[rdf.last[1]][rdf.last[0]].subjects.length; i++) {
					if (rdf.maxMonth < rdf.works[rdf.last[1]][rdf.last[0]].subjects[i].substr(-7, 6)) {
						rdf.maxMonth = rdf.works[rdf.last[1]][rdf.last[0]].subjects[i].substr(-7, 6);
					}
				}
				clearInterval(timerId);
				d.resolve();
			}
		}, 100);
	} else {
		d.resolve();
	}
	return d.promise();
}

function setFormats() {
//フォーム設定のチェックと取得
	var d = $.Deferred();
	//入力チェック
	var alertString = "";
	if (!($("#affiliate1").attr("checked") ||
		  $("#affiliate2").attr("checked") ||
		  $("#affiliate3").attr("checked"))) {
		alertString = "系列を一つ以上選択してください";
	}
	var reEx = new RegExp("^[0-9][0-9][0-9][0-9][0-9][0-9]$");
	if (reEx.test($("#month").val()) &&
		$("#month").val().substr(-2) >= "01" &&
		$("#month").val().substr(-2) <= "12" &&
		$("#month").val() >= rdf.minMonth &&
		$("#month").val() <= rdf.maxMonth) {
	} else {
		alertString = "指定された年月の指数値はありません";
	}
	if (!($("#item1").attr("checked") ||
		  $("#item2").attr("checked") ||
		  $("#item3").attr("checked") ||
		  $("#item4").attr("checked"))) {
		alertString = "アイテムを一つ以上選択してください";
	}
	switch ($("input[name='unit']:checked").val()) {
		case "2":
			if ($("#month").val().substr(-2) == "01") {
				if ($("#month").val() - 100 + 11 < rdf.minMonth) {
					alertString = "指定された年月の前月値はありません";
				}
			} else {
				if ($("#month").val() - 1 < rdf.minMonth) {
					alertString = "指定された年月の前月値はありません";
				}
			}
			break;
		case "3":
			if ($("#month").val() - 100 < rdf.minMonth) {
				alertString = "指定された年月の前年同月値はありません";
			}
			break;
	}
	if (alertString) {
		$("#info").empty().append("設定エラー");
		$("#result").empty();
		alert(alertString);
		d.reject();
		return d.promise();
	}
	//チェックを抜けたら設定を格納していく
	formats = {};
	//系列
	formats.codeInitials = [];
	if ($("#affiliate3").attr("checked") == "checked") {
		formats.codeInitials.push("1");
	}
	if ($("#affiliate1").attr("checked") == "checked") {
		formats.codeInitials.push("2");
		formats.codeInitials.push("3");
	}
	if ($("#affiliate2").attr("checked") == "checked") {
		formats.codeInitials.push("4");
		formats.codeInitials.push("5");
	}
	//年月
	formats.years = [$("#month").val().substr(0, 4)];
	formats.months = [$("#month").val()];
	//アイテム
	formats.itemNames = [];
	if ($("#item1").attr("checked") == "checked") {
		formats.itemNames.push("_Production");
	}
	if ($("#item2").attr("checked") == "checked") {
		formats.itemNames.push("_Shipments");
	}
	if ($("#item3").attr("checked") == "checked") {
		formats.itemNames.push("_Inventory");
	}
	if ($("#item4").attr("checked") == "checked") {
		formats.itemNames.push("_InventoryRatio");
	}
	//種類
	formats.properties = ["name"];
	switch ($("input[name='type']:checked").val()) {
		case "1":
			formats.properties.push("original_index");
			break;
		case "2":
			formats.properties.push("seasonally_adjusted_index");
			break;
	}
	//単位
	switch ($("input[name='unit']:checked").val()) {
		case "2":
			if (formats.months[0].substr(-2) == "01") {
				formats.years.push(String(formats.years[0] - 1));
				formats.months.push(String(formats.months[0] - 100 + 11));
			} else {
				formats.months.push(String(formats.months[0] - 1));
			}
			break;
		case "3":
			formats.years.push(String(formats.years[0] - 1));
			formats.months.push(String(formats.months[0] - 100));
			break;
	}
	$("#info").empty().append("設定ロード完了");
	d.resolve();
	return d.promise();
}

function waitRdfGot() {
//使いたいオブジェクトのあるファイルのサブジェクトが取得完了してるかを判定
	$("#info").empty().append("データロード中…");
	var d = $.Deferred();
	var reEx = new RegExp("^IIP_Base2010_Year(" + formats.years.join("|") + ")(" + formats.itemNames.join("|") + ")$");
	var timerId = setInterval(function() {
		var allLoaded = true;
		for (var work in rdf.works) {
			for (var file in rdf.works[work]) {
				if (reEx.test(file) && !rdf.works[work][file].loaded) {
					allLoaded = false;
				}
			}
		}
		if (allLoaded) {
			clearInterval(timerId);
			d.resolve();
		}
	}, 100);
	return d.promise();
}

function getObjectsAndForget(workId, fileName, subject, property) {
//LinkData.getObjectsの撃ちっ放し版
	LinkData.getObjects(workId, fileName,
						"http://linkdata.org/resource/" + workId + "#" + subject,
						"http://linkdata.org/property/" + workId + "#" + property,
						function(res) {
							data[subject][property] = res[0];
						});
}

function getData() {
//formatsに格納された設定の通りにオブジェクトを取得してdataに入れる
	var d = $.Deferred();
	//データを取りに行くワーク・ファイル・サブジェクト・プロパティを決定する
	var necessary = [];
	for (var work in rdf.works) {
		necessary[work] = {};
		for (var file in rdf.works[work]) {
			//対象年の対象アイテムのファイルであるか
			var reEx = new RegExp("^IIP_Base2010_Year(" + formats.years.join("|") + ")(" + formats.itemNames.join("|") + ")$");
			if (reEx.test(file)) {
				necessary[work][file] = {};
				for (var i = 0; i < rdf.works[work][file].subjects.length; i++) {
					//対象系列の対象年月のサブジェクトであるか
					reEx = new RegExp("^(" + formats.codeInitials.join("|") + ").........(" + formats.months.join("|") + ")[1345]$");
					if (reEx.test(rdf.works[work][file].subjects[i])) {
						var subject = rdf.works[work][file].subjects[i];
						//当月なら全プロパティが、過去月なら指数値だけが対象
						if (subject.substr(-7, 6) == formats.months[0]) {
							necessary[work][file][subject] = formats.properties;
						} else {
							necessary[work][file][subject] = [formats.properties[formats.properties.length - 1]];
						}
					}
				}
			}
		}
		//枝が作られなかったワークは消す
		if (Object.keys(necessary[work]).length == 0) {
			delete necessary[work];
		}
	}
	//データ格納先のオブジェクトをnullで埋めてガワだけ作る
	data = {};
	var dataSize = 0;
	for (var work in necessary) {
		for (var file in necessary[work]) {
			for (var subject in necessary[work][file]) {
				data[subject] = {};
				for (var i = 0; i < necessary[work][file][subject].length; i++) {
					data[subject][necessary[work][file][subject][i]] = null;
					dataSize++;
				}
			}
		}
	}
	//0.5秒間隔でデータを走査しnullならオブジェクトを問い合わせる
	var inquiry = {};
	var timerId = setInterval(function() {
		var nullCount = 0;
		for (var work in necessary) {
			for (var file in necessary[work]) {
				for (var subject in necessary[work][file]) {
					for (var i = 0; i < necessary[work][file][subject].length; i++) {
						var property = necessary[work][file][subject][i];
						if (data[subject][property] == null) {
							nullCount++;
							//以前問い合わせてから10ターン（5秒）以内なら何もしない
							//それ以上経ってるか初回なら問い合わせる
							if (inquiry[subject + property]) {
								inquiry[subject + property]--;
							} else {
								getObjectsAndForget(work, file, subject, property);
								inquiry[subject + property] = 10;
							}
						}
					}
				}
			}
		}
		$("#info").empty().append("データロード中…（" + (dataSize - nullCount) + " / " + dataSize + "）");
		if (nullCount == 0) {
			clearInterval(timerId);
			$("#info").empty().append("データロード完了");
			d.resolve();
		}
	}, 500);
	return d.promise();
}

function makeTable() {
//dataオブジェクトの内容を表示用に整形して更新
	$("#info").empty().append("表ロード中…");
	//表示用にソートしたIDの配列を作る
	var sortedId = [];
	for (var key in data) {
		if (key.substr(-7, 6) == formats.months[0]) {
			sortedId.push(key);
		}
	}
	sortedId.sort();
	//tableタグ以下を生成
	var htmlString = "<table><tr><th>品目番号</th><th>名称</th><th>年月</th><th>アイテム</th>";
	switch ($("input[name='unit']:checked").val()) {
		case "1":
			htmlString += "<th>指数値</th>"
			break;
		case "2":
			htmlString += "<th>前月比</th>"
			break;
		case "3":
			htmlString += "<th>前年比</th>"
			break;
	}
	htmlString += "</tr>"
	for (var i = 0; i < sortedId.length; i++) {
		if (i % 2 == 0) {
			htmlString += '<tr class="oddrow">';
		} else {
			htmlString += "<tr>";
		}
		htmlString += "<td>" + sortedId[i].substr(0, 10) + "</td>";
		htmlString += "<td>" + data[sortedId[i]]["name"] + "</td>";
		htmlString += "<td>" + sortedId[i].substr(10, 6) + "</td>";
		switch (sortedId[i].substr(-1)) {
			case "1":
				htmlString += "<td>生産</td>";
				break;
			case "3":
				htmlString += "<td>出荷</td>";
				break;
			case "4":
				htmlString += "<td>在庫</td>";
				break;
			case "5":
				htmlString += "<td>在庫率</td>";
				break;
		}
		if ($("input[name='unit']:checked").val() == "1") {
			htmlString += "<td>" + data[sortedId[i]][formats.properties[formats.properties.length - 1]] + "</td>";
		} else {
			htmlString += "<td>" + (Math.round(data[sortedId[i]][formats.properties[formats.properties.length - 1]] / data[sortedId[i].substr(0, 10) + formats.months[1] + sortedId[i].substr(-1)][formats.properties[formats.properties.length - 1]] * 1000) / 10) + "</td>";
		}
		htmlString += "</tr>";
	}
	htmlString += "</table>";
	delete formats;
	delete data;
	$("#info").empty().append("表ロード完了");
	$("#result").empty().append(htmlString).trigger("create");
}

jQuery(function($) {
	rdf = {};
	rdf.loaded = getRdfFormat();//裏でサブジェクトを読ませておく
	$("#affiliate1").attr("checked", true);//系列
	$("#month").val("201401");//年月
	$("#item1").attr("checked", true);//アイテム
	$("input[name='type']").val([2]);//種類
	$("input[name='unit']").val([1]);//単位
	$("#info").empty().append("ページロード完了");
	$("#result").empty();
});

window.onload = function() {
}

$("button").click(function() {
	$("#result")
		.empty()
		.append('<img class="loading" src="http://app.linkdata.org/asset/ec4b2e3d.gif" alt="LoadingImage">');
	waitLimitGot()
		.pipe(setFormats)
		.pipe(waitRdfGot)
		.pipe(getData)
		.pipe(makeTable);
});
