/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/


// グローバル変数
eventlist_data	= new Array();	// イベントリスト
genre_data		= new Array();	// イベントジャンルリスト
spot_data		= new Array();	// スポットリスト 
eventtime_data	= new Array();	// イベントタイムテーブル

var user_lat	= '';			// ユーザの緯度
var user_lng	= '';			// ユーザの経度
var sel_spot_id = null;
var map;						
var currentWindow = null;		// 表示中のinfoWindow

// ページが表示されたときに関数を呼び出す
$('#list').bind('pageshow',checkChoice);
$('#detail').bind('pageshow',detailMapCanvas);
$('#map').bind('pageshow',mapCanvas);

// 画面起動時の関数
window.onload = function() {
	initialize();
	//ユーザーの現在の位置情報を取得
	navigator.geolocation.getCurrentPosition(successCallback, errorCallback);
}

// 初期化の関数
function initialize(){
	//現在地の取得
	getGeoLocation();
	// LinkDataからデータの読み込み
	loadData();

}

//######################################################################################################################################
//  地図関連
//######################################################################################################################################

//--------------------------------------
//  位置情報関連
//--------------------------------------

// 位置情報の取得
function getGeoLocation(){
	
	// HTML5 geolocation 機能で現在地を取得
	if(navigator.geolocation) {
		navigator.geolocation.getCurrentPosition(function(position) {
			// ユーザの現在位置を取得
			user_lat = position.coords.latitude; user_lng = position.coords.longitude;	// オリジナル
			//user_lat = 35.177541; user_lng = 137.087564;								// 公園駅
			//user_lat = 35.173806; user_lng = 137.089160;								// プール
			//user_lat = 35.168942; user_lng = 137.092158;								// 展望塔
			//user_lat = 35.182279; user_lng = 137.021347;								// 藤が丘駅
			//user_lat = 35.154545; user_lng = 136.961582;								// 名大
			//user_lat = 35.181448; user_lng = 136.915955;								//佐助邸
			var user_pos = new google.maps.LatLng(user_lat, user_lng);
			
		}, function() {
			handleNoGeolocation(true);
		});
	} else {
		// ブラウザがGeolocationをサポートしていない
		handleNoGeolocation(false);
	}
	
}

// 位置情報取得のエラー処理
function handleNoGeolocation(errorFlag) {
	if (errorFlag) {
		var content = '位置情報が取得できませんでした';
	} else {
		var content = 'ブラウザが位置情報機能に対応していません';
	}
	alert(content);
}


// 測地線航海算法の公式
function geoDistance(lat1, lng1, lat2, lng2, precision) {
  // 引数　precision は小数点以下の桁数（距離の精度）
  var distance = 0;
  if ((Math.abs(lat1 - lat2) < 0.00001) && (Math.abs(lng1 - lng2) < 0.00001)) {
    distance = 0;
  } else {
    lat1 = lat1 * Math.PI / 180;
    lng1 = lng1 * Math.PI / 180;
    lat2 = lat2 * Math.PI / 180;
    lng2 = lng2 * Math.PI / 180;
 
    var A = 6378140;
    var B = 6356755;
    var F = (A - B) / A;
 
    var P1 = Math.atan((B / A) * Math.tan(lat1));
    var P2 = Math.atan((B / A) * Math.tan(lat2));
 
    var X = Math.acos(Math.sin(P1) * Math.sin(P2) + Math.cos(P1) * Math.cos(P2) * Math.cos(lng1 - lng2));
    var L = (F / 8) * ((Math.sin(X) - X) * Math.pow((Math.sin(P1) + Math.sin(P2)), 2) / Math.pow(Math.cos(X / 2), 2) - (Math.sin(X) - X) * Math.pow(Math.sin(P1) - Math.sin(P2), 2) / Math.pow(Math.sin(X), 2));
 
    distance = A * (X + L);
    var decimal_no = Math.pow(10, precision);
    distance = Math.round(decimal_no * distance / 1) / decimal_no;   // kmに変換するときは(1000で割る)
  }
  return distance;
}

//--------------------------------------
//  全体マップ
//--------------------------------------

// 全体地図の表示
function mapCanvas() {
	
	createMap('map-canvas');
	
	// スポットにマーカーを設置
	var spotIcon =  new google.maps.MarkerImage('http://app.linkdata.org/asset/a5b95d25.png');
	spotIcon.scaledSize = new google.maps.Size(32, 51);
	
	for (var i in spot_data){
		if (spot_data[i].name) {
			// マップにマーカーを追加
			var spot_pos = new google.maps.LatLng(spot_data[i].lat, spot_data[i].lng);
			var contentString = '<b>'+ spot_data[i].name+'</b>';
			createMarker(spot_data[i].id,contentString,spot_pos,spotIcon,map);
		}
	}
	
	// マップの画面を合わせる
	var pageHeight = $(document).height();
	$("#map-canvas").css("height",pageHeight - 40);
}

// マップ作成
function createMap(divId){
	
	var mapOptions = {
		zoom: 16,
		mapTypeControl: false,
		streetViewControl: false,
		panControl: false,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	map = new google.maps.Map(document.getElementById(divId),mapOptions);
	
	// HTML5 geolocation 機能で現在地を取得
	if(navigator.geolocation) {
		navigator.geolocation.getCurrentPosition(function(position) {
			// 地図の中央を佐助邸へ
			var mori_pos = new google.maps.LatLng(35.181448, 136.915955);
			map.setCenter(mori_pos);
			
			// ユーザの現在位置にマーカーを設置
			user_lat = position.coords.latitude;
			user_lng = position.coords.longitude;
			var user_pos = new google.maps.LatLng(user_lat, user_lng);
			var userIcon = new google.maps.MarkerImage('http://app.linkdata.org/asset/407e87a1.png');
			userIcon.scaledSize = new google.maps.Size(55, 55);
			
			var user_mk = new google.maps.Marker({
				 position: user_pos,
				 map: map,
				 icon: userIcon,
				 title: '現在位置'
			});
			var user_iw = new google.maps.InfoWindow({
				content: '現在位置'
			});
			google.maps.event.addListener(user_mk, 'click', function() {
				user_iw.open(map,user_mk);
			});
			
		}, function() {
			mapNoGeolocation(true);
		});
	} else {
		// ブラウザがGeolocationをサポートしていない
		mapNoGeolocation(false);
	}
	
}


// スポットマーカーの設置
function createMarker(id,content,latlng,icon,map){
	var spot_iw = new google.maps.InfoWindow();

		
	var spot_mk = new google.maps.Marker({
		id: id,
		position: latlng,
		map: map,
		icon: icon
	});
	
	google.maps.event.addListener(spot_mk, 'click', function() {
		if (currentWindow) {
			currentWindow.close();
		}
		spot_iw.setContent(content);
		spot_iw.open(map,spot_mk);
		currentWindow = spot_iw;
	});
} 


// エラー処理
function mapNoGeolocation(errorFlag) {
	if (errorFlag) {
		var content = '位置情報が取得できませんでした';
	} else {
		var content = 'ブラウザが位置情報機能に対応していません';
	}
	
	var options = {
		map: map,
		zoom: 15,
		position: new google.maps.LatLng(35.172778, 137.089797),
		content: content
	};
	var infowindow = new google.maps.InfoWindow(options);
	map.setCenter(options.position);
}



//######################################################################################################################################
//  リスト表示関連
//######################################################################################################################################
//---------------------------------------------
//  イベントリストの表示
//---------------------------------------------

// イベントを探すボタン
function checkChoice () {
	
	// 絞り込みラジオボタンの値
	var radio = $('[name=time_choice]:checked').val();
	
	if (radio == 'now') {
		showEnableEvent ();
	} else if (radio == 'soon'){
		showSoonEvent ();
	} else if (radio == 'all') {
		showEventList ();
	}
	
	
	//showEventList ();
	
	
}


// イベント情報の読み込み
function showEventList () {

	// ページ初期化
	$('.eventList').empty();
	
	// イベントリストの作成
	var eventCn  = 0; // イベント数のカウント
	var eventSum = 0; // イベント数合計

	// イベントタイムテーブルをループ
	for (var i in eventtime_data) {
		var event_id = eventtime_data[i].event_id;
		var onclick = 'onclick="showDetail('+  event_id  + ')"';
	
		// イベントリストをループさせ、該当するイベントを抜き出す
		for (var j in eventlist_data) {
			if (eventtime_data[i].event_id == eventlist_data[j].id) {
				var li = '';
				var devider = '';

				//---------------------
				//  リスト区切りとイベント数表示について
				//---------------------
				// リスト1行目の場合
				if (i == 0){
					// 日付毎のセクション区切りを挿入
					devider = '<li data-role="list-divider">'+ eventtime_data[i].date +'のイベント一覧<span class="ui-li-count '+ eventtime_data[i].date2 +'event"></span></li>';
					$('.eventList').append(devider);
					
				// リスト最終行の場合
				} else if (i == eventtime_data.length - 1) {
					// 最終セクションのイベント数欄に値を代入
					var str = '.'+ eventtime_data[i].date2 +'event';
					$(str).append(eventCn + 1);
					//$('.eventList').append(devider);
				// 日付が変わった場合	
				} else if (eventtime_data[i].date != eventtime_data[i-1].date){
					// 前のセクションのイベント数欄に値を代入
					var str = '.'+ eventtime_data[i-1].date2 +'event';
					$(str).append(eventCn);
					// イベント数カウントを初期化
					eventCn = 0;
					// 日付毎のセクション区切りを挿入
					devider = '<li data-role="list-divider">'+ eventtime_data[i].date +'のイベント一覧<span class="ui-li-count '+ eventtime_data[i].date2 +'event"></span></li>';
					$('.eventList').append(devider);
				}
				
				//---------------------
				//  各イベントの内容をリストに加えるところ
				//---------------------
				
				// このあたりで、チェックボックスの選択によって、表示に加えるか否かを振り分ける予定
				
				// リンク部分
				li = li + '<li><a href="#detail" data-transition="slide" '+ onclick +'>';
				// イベントジャンル
				li = li + '<p style="font-size:70%;">'+ eventlist_data[j].genre +'</p>';
				var genre_id = eventlist_data[j].genre_id;
				
				// 開始時刻（なければ「未定」表示）
				if (eventtime_data[i].start) {
					li = li + '<p class="ui-li-aside"><span style="font-size:130%;">'+ eventtime_data[i].start +'</span> ~ ';
				} else {
					li = li + '<p class="ui-li-aside"><span style="font-size:130%;">未定</span> ~';
				}
				// 終了時刻（なければ表示しない）
				if (eventtime_data[i].end) {
					li = li + '<span style="font-size:90%;">'+ eventtime_data[i].end +'</span>';
				}
				// イベント名
				li = li + '</p><h4>'+ eventlist_data[j].title +'</h4>';
				// イベント紹介文（なければ表示しない）
				if (eventlist_data[j].text) {
					li = li + '<p><b>'+ eventlist_data[j].text +'</b></p>';
				}
				// 内容 （なければ表示しない）
				if (eventtime_data[i].text) {
					li = li + '<p><b>'+ eventtime_data[i].text +'</b></p>';
				}
				// 場所
				li = li + '<p>●'+ eventlist_data[j].spot +'</p></a></li>';
				
				
			}
			
		}
		// リストに追加
		var genre_choice = '#genre_'+ genre_id;
		if ($(genre_choice).prop('checked')) {
			$('.eventList').append(li);
			// イベント数カウントを増やす
			eventCn++;
			eventSum++;
		}

	}
	// 全てのイベント数を表示
	$('.allEventCount').empty();
	$('.allEventCount').append(eventSum);
	
	// CSSの初期化
	$('.eventList').listview().listview('refresh'); // イベントリスト
	
}


//開催中のイベント情報読み込み
function showEnableEvent(){
	$('.eventList').empty();
	$('.allEventCount').empty();
	var eventCn= 0;
	var eventSum= 0;

	//var cr_time = new Date(2014,10,3,11,0);
	var cr_time = new Date();
	var year= cr_time.getFullYear();
	var month= cr_time.getMonth()+1;
	var day= cr_time.getDate();
	var hour= cr_time.getHours();
	var minutes= cr_time.getMinutes();
	

	
	if(year!==2014 || month!==11 || day!==3){
		$('.eventList').append('<li>本日開催のイベントはありません。<br>歩こう！文化のみちは11/3開催です。</li>');	
	}else{
		//イベントタイムテーブルをループさせ、イベントidを取り出す
			for (var i in eventtime_data) {
				var event_id = eventtime_data[i].event_id;
				var onclick = 'onclick="showDetail('+  event_id  + ')"';//クリックするとidに即した詳細ページにとぶ
	
				if(eventtime_data[i].s_time){	//開始時間が入っているとき
		
					if(eventtime_data[i].e_time){	//終了時間が入っているとき
			
						if(cr_time.getTime() + 60 * 1000 > eventtime_data[i].s_time.getTime()){	//もう始まっているイベント
			
							if(cr_time.getTime() < eventtime_data[i].e_time.getTime()){	//まだ終わっていないイベント
							
								// イベントリストをループさせ、該当するイベントを抜き出す
								for (var j in eventlist_data) {
									if (eventtime_data[i].event_id == eventlist_data[j].id) {
										var li = '';
										var devider = '';

										//---------------------
										//  リスト区切りとイベント数表示について
										//---------------------
										// リスト1行目の場合
			
										if (i == 0){
											// 日付毎のセクション区切りを挿入
											devider = '<li data-role="list-divider">'+ eventtime_data[i].date +' '+ hour +':'+ minutes +' '+'現在のイベント一覧<span class="ui-li-count '+ eventtime_data[i].date2 +'event"></span></li>';
											$('.eventList').append(devider);
					
											// リスト最終行の場合
										} else if (i == eventtime_data.length - 1) {

											// 最終セクションのイベント数欄に値を代入
											var str = '.'+ eventtime_data[i].date2 +'event';
											$(str).append(eventCn + 1);
										}
		
										//---------------------
										//  各イベントの内容をリストに加えるところ
										//---------------------
				
										// リンク部分
										li = li + '<li><a href="#detail" data-transition="slide" '+ onclick +'>';
										// イベントジャンル
										li = li + '<p style="font-size:70%;">'+ eventlist_data[j].genre +'</p>';
										var genre_id = eventlist_data[j].genre_id;
				
										// 開始時刻（なければ「未定」表示）
										if (eventtime_data[i].start) {
											li = li + '<p class="ui-li-aside"><span style="font-size:130%;">'+ eventtime_data[i].start +'</span> ~ ';
										} else {
											li = li + '<p class="ui-li-aside"><span style="font-size:130%;">未定</span> ~';
										}
										// 終了時刻（なければ表示しない）
										if (eventtime_data[i].end) {
											li = li + '<span style="font-size:90%;">'+ eventtime_data[i].end +'</span>';
										}
										// イベント名
										li = li + '</p><h4>'+ eventlist_data[j].title +'</h4>';
										// イベント紹介文（なければ表示しない）
										if (eventlist_data[j].text) {
											li = li + '<p><b>'+ eventlist_data[j].text +'</b></p>';
										}
										// 内容 （なければ表示しない）
										if (eventtime_data[i].text) {
											li = li + '<p><b>'+ eventtime_data[i].text +'</b></p>';
										}
										// 場所
										li = li + '<p>●'+ eventlist_data[j].spot +'</p></a></li>';
				
										// リストに追加
										var genre_choice = '#genre_'+ genre_id;
										if ($(genre_choice).prop('checked')) {
											$('.eventList').append(li);
											// イベント数カウントを増やす
											eventCn++;
											eventSum++;		
										}		
					
									}//ifおわり
					
								}//forイベントリストループおわり
		
							}	//if今とエンド比較おわり
	
						}//if今とスタート比較終わり			

					}else if(cr_time.getTime() + 60 * 1000 > eventtime_data[i].s_time.getTime()){	//開始時間のみが入っているとき
			
						for (var j in eventlist_data){

							if (eventtime_data[i].event_id == eventlist_data[j].id) {
					
								var ad = '';
								var devider = '';
								
								//---------------------
								//  各イベントの内容をリストに加えるところ
								//---------------------
				
								// リンク部分
								ad = ad + '<li><a href="#detail" data-transition="slide" '+ onclick +'>' ;
								// イベントジャンル
								ad = ad + '<p style="font-size:70%;">'+ eventlist_data[j].genre +'</p>';
								var genre_id = eventlist_data[j].genre_id;
				
								// 開始時刻（なければ「未定」表示）
								if (eventtime_data[i].start) {
									ad = ad + '<p class="ui-li-aside"><span style="font-size:130%;">'+ eventtime_data[i].start +'</span> ~ ';
								} else {
									ad = ad + '<p class="ui-li-aside"><span style="font-size:130%;">未定</span> ~';
								}
								// 終了時刻（なければ表示しない）
								if (eventtime_data[i].end) {
									ad = ad + '<span style="font-size:90%;">'+ eventtime_data[i].end +'</span>';
								}
								// イベント名
								ad = ad + '</p><h4>'+ eventlist_data[j].title +'</h4>';
								// イベント紹介文（なければ表示しない）
								if (eventlist_data[j].text) {
									ad = ad + '<p><b>'+ eventlist_data[j].text +'</b></p>';
								}
								// 内容 （なければ表示しない）
								if (eventtime_data[i].text) {
									ad = ad + '<p><b>'+ eventtime_data[i].text +'</b></p>';
								}
								// 場所
									ad = ad + '<p>●'+ eventlist_data[j].spot +'</p></a></li>';
				
								// リストに追加
								var genre_choice = '#genre_'+ genre_id;
								if ($(genre_choice).prop('checked')) {
								$('.eventList').append(ad);
								// イベント数カウントを増やす
								eventCn++;
								eventSum++;		
								}	
							
							}	//ifおわり

						}	//forおわり
						
					}	//else if 開始時間のみ入っているときおわり

				}	//if開始時間はいっているかチェックおわり
		
			}//for終わり
				
		// 全てのイベント数を表示
		$('.allEventCount').empty();
		$('.allEventCount').append(eventSum);
	
	}//else終わり
	
	$('.eventList').listview().listview('refresh');	//css初期化
}	//functionおわり


//もうすぐ始まるイベント情報読み込み
function showSoonEvent(){
	$('.eventList').empty();
	$('.allEventCount').empty();
	var eventCn= 0;
	var eventSum= 0;

	//var cr_time = new Date(2014,10,3,11,0);
	var cr_time = new Date();
	var year= cr_time.getFullYear();
	var month= cr_time.getMonth()+1;
	var day= cr_time.getDate();
	var hour= cr_time.getHours();
	var minutes= cr_time.getMinutes();
	
	
	if(year!==2014 || month!==11 || day!==3){
		$('.eventList').append('<li>本日開催のイベントはありません。<br>歩こう！文化のみちは11/3開催です。</li>');	//クリア
	}else{
		//イベントタイムテーブルをループさせ、イベントidを取り出す
		for (var i in eventtime_data) {
			var event_id = eventtime_data[i].event_id;
			var onclick = 'onclick="showDetail('+  event_id  + ')"';//クリックするとidに即した詳細ページにとぶ
	
			if(eventtime_data[i].s_time){	//開始時間が入っているとき
			
				if((cr_time.getTime() + 61*60*1000 > eventtime_data[i].s_time.getTime()) && (eventtime_data[i].s_time.getTime() > cr_time.getTime())){	//1時間以内に始まるイベントは
			
					for (var j in eventlist_data) {
				
						if (eventtime_data[i].event_id == eventlist_data[j].id) {
							var li = '';
							var devider = '';

							//---------------------
							//  リスト区切りとイベント数表示について
							//---------------------
							// リスト1行目の場合
							
							if (i == 0){
							// 日付毎のセクション区切りを挿入
								devider = '<li data-role="list-divider">'+ eventtime_data[i].date +' '+ hour +':'+ minutes +' '+'から1時間以内に開催するイベント一覧<span class="ui-li-count '+ eventtime_data[i].date2 +'event"></span></li>';
								$('.eventList').append(devider);
					
							// リスト最終行の場合
							} else if (i == eventtime_data.length - 1) {
								// 最終セクションのイベント数欄に値を代入
								var str = '.'+ eventtime_data[i].date2 +'event';
								$(str).append(eventCn + 1);
							}
		
							//---------------------
							//  各イベントの内容をリストに加えるところ
							//---------------------
									
							// リンク部分
							li = li + '<li><a href="#detail" data-transition="slide" '+ onclick +'>';
							// イベントジャンル
							li = li + '<p style="font-size:70%;">'+ eventlist_data[j].genre +'</p>';
							var genre_id = eventlist_data[j].genre_id;
				
							// 開始時刻（なければ「未定」表示）
							if (eventtime_data[i].start) {
								li = li + '<p class="ui-li-aside"><span style="font-size:130%;">'+ eventtime_data[i].start +'</span> ~ ';
							} else {
								li = li + '<p class="ui-li-aside"><span style="font-size:130%;">未定</span> ~';
							}
							// 終了時刻（なければ表示しない）
							if (eventtime_data[i].end) {
								li = li + '<span style="font-size:90%;">'+ eventtime_data[i].end +'</span>';
							}
							// イベント名
							li = li + '</p><h4>'+ eventlist_data[j].title +'</h4>';
							// イベント紹介文（なければ表示しない）
							if (eventlist_data[j].text) {
								li = li + '<p><b>'+ eventlist_data[j].text +'</b></p>';
							}
							// 内容 （なければ表示しない）
							if (eventtime_data[i].text) {
								li = li + '<p><b>'+ eventtime_data[i].text +'</b></p>';
							}
							// 場所
							li = li + '<p>●'+ eventlist_data[j].spot +'</p></a></li>';
					
						}//ifおわり
			
					}//forイベントリストループおわり
				
					// リストに追加
					var genre_choice = '#genre_'+ genre_id;
				
					if ($(genre_choice).prop('checked')) {
						$('.eventList').append(li);
						// イベント数カウントを増やす
						eventCn++;
						eventSum++;
					}
		
				}//ifまだ始まっていないイベントで1時間以内に始まるイベント選びおわり
				
			}//if開始時間チェックおわり
			
		}//for終わり

		// 全てのイベント数を表示
		$('.allEventCount').empty();
		$('.allEventCount').append(eventSum);
	
	}//if終わり
	
	$('.eventList').listview().listview('refresh');//css初期化
}	//functionおわり



//######################################################################################################################################
//  イベント詳細ページ関連
//######################################################################################################################################

//--------------------------------------------
// イベント詳細ページ
//--------------------------------------------

// イベント詳細ページを開く
function showDetail(event_id) {
	// テーブルの配列に合わせる
	var id = event_id - 1;
	n = eventlist_data[id].spot_id;
	sel_spot_id = eventlist_data[id].spot_id;
	// ページ初期化
	$('#detail-content').empty();
	
	
	// イベントジャンル
	if (eventlist_data[id].genre){
		$('#detail-content').append('<p style="font-size:80%;">'+ eventlist_data[id].genre +'</p>');
	}
	// イベントタイトル
	$('#detail-content').append('<h3>'+ eventlist_data[id].title +'</h3>');
	
	// 本文
	if (eventlist_data[id].text){
		$('#detail-content').append('<p>'+ eventlist_data[id].text +'</p>');
	}
	
	//画像
	if (spot_data[n-1].img){
		$('#detail-content').append('<img style= "width: 250px; height: 200px;" src="'+ spot_data[n-1].img +'"</img>');
	}
	
	//---------------------------
	// 情報テーブルの作成
	//---------------------------
 	var table = '<table id="tbl" data-role="table" data-mode="column-toggle" class="ui-responsive"><thead></thead><tbody>';
	

	// 日時
	table = table + '<tr><td class="event-table-item">日時</td><td>'
	
	for (var i in eventtime_data){
		if (event_id == eventtime_data[i].event_id){
			table = table + '<p>'+ eventtime_data[i].date +' '+ eventtime_data[i].start +'~'+ eventtime_data[i].end +'</p>';
		}
	}

	table = table + '</td></tr>'

	// スポット
	if (eventlist_data[id].spot){
		table = table + '<tr><td class="event-table-item">場所</td><td>'+ eventlist_data[id].spot +'</td></tr>';
	}
	
	// 会場
	if (eventlist_data[id].place){
		table = table + '<tr><td class="event-table-item">会場</td><td>'+ eventlist_data[id].place +'</td></tr>';
	}

	// 料金
	if (eventlist_data[id].fee){
		if (eventlist_data[id].fee == '0'){
			table = table + '<tr><td class="event-table-item">料金</td><td>無料</td></tr>'
		} else {
			table = table + '<tr><td class="event-table-item">料金</td><td>'+ eventlist_data[id].fee +'</td></tr>';
		}
	}
	
	// 定員
	if (eventlist_data[id].limit && eventlist_data[id].limit != '0'){
		table = table + '<tr><td class="event-table-item">定員</td><td>'+ eventlist_data[id].limit +'</td></tr>';
	}

	// バスアクセス
	if (spot_data[n-1].bus){
		table = table + '<tr><td class="event-table-item">バスで行く</td><td>'+ spot_data[n-1].bus +'</td></tr>';
	}

	// 地下鉄アクセス
	if (spot_data[n-1].subway){
		table = table + '<tr><td class="event-table-item">電車で行く</td><td>'+ spot_data[n-1].subway +'</td></tr>';
	}
		
	// スタンプラリーNO
	if (spot_data[n-1].stamp){
		table = table + '<tr><td class="event-table-item">スタンプNO</td><td>'+ spot_data[n-1].stamp +'</td></tr>';
	}
	// 備考
	if (eventlist_data[id].info){
		table = table + '<tr><td class="event-table-item">備考</td><td>'+ eventlist_data[id].info +'</td></tr>';
	}


	table = table + '</tbody></table>'
		
	$('#detail-content').append(table);
	$('</table>').appendTo( ".ui-page" ).trigger( "create" );
	
}



//--------------------------------------
//  イベント詳細マップ
//--------------------------------------

// イベント詳細画面の地図
function detailMapCanvas() {
	var id = sel_spot_id - 1;
	
	createDetailMap('detail-map-canvas');
	
	// スポットにマーカーを設置
	var spotIcon =  new google.maps.MarkerImage('http://app.linkdata.org/asset/a5b95d25.png');
	spotIcon.scaledSize = new google.maps.Size(32, 51);
	var pos = new google.maps.LatLng(spot_data[id].lat, spot_data[id].lng);
	var distance = geoDistance(user_lat, user_lng, spot_data[id].lat, spot_data[id].lng, -1);
			
	// マーカーの内容
	var str = '';
	var str2 = '';
	
	// 1km以内の場合
	if (distance < 1000) {
		// 徒歩時分を計算
		//var walk_time = Math.round(distance / 50);
		// 到着時刻を計算
		//var ar_time = new Date(cr_time.getTime() + walk_time * 60 * 1000);
		//var hour 	= ar_time.getHours();
		//var min 	= ar_time.getMinutes();
		//if (min < 10) {
		//	min = '0' + min;
		//}
		// 表示する形ににまとめる
		str = '<br>約'+ distance + 'm';
		//str = '<br>約'+ distance + 'm, 徒歩約'+ walk_time +'分, '+ hour +':'+ min +'頃到着見込';
		//str2 = '<br>徒歩約'+ walk_time +'分';
		
		// 4km以内の場合
	} else if (distance < 4000) {
		
		// 徒歩時分を計算
		//var walk_time = Math.round(distance / 50);
		// 到着時刻を計算
		//var ar_time = new Date(cr_time.getTime() + walk_time * 60 * 1000);
		//var hour 	= ar_time.getHours();
		//var min 	= ar_time.getMinutes();
		//if (min < 10) {
		//	min = '0' + min;
		//}
		// 表示する形ににまとめる
		var dis_str = Math.round(distance / 100) / 10;
		str = '<br>約'+ dis_str + 'km';
		//str = '<br>約'+ dis_str + 'km, 徒歩約'+ walk_time +'分, '+ hour +':'+ min +'頃到着見込';
		//str2 = '<br>徒歩約'+ walk_time +'分';
		
	// 10km以内の場合
	} else if (distance < 10000) {
		var dis_str = Math.round(distance / 100) / 10;
		str = '<br>約'+ dis_str + 'km';
	} 
	
	var content = '<b>'+ spot_data[id].name+'</b>'+ str2;		// 
	var contentString = '<b>アクセス</b> <a href="http://maps.google.com/maps?q='+ spot_data[id].lat +','+ spot_data[id].lng +'" target="_blank">マップで開く</a>'+ str;	// 
	
	// マップにマーカーを追加
	createDetailMarker(id,content,pos,spotIcon,map);
	
	// 地図の中央をスポットへ
	var lat = parseFloat(spot_data[id].lat) + 0.0009;
	var pos = new google.maps.LatLng(lat, spot_data[id].lng);
	map.setCenter(pos);
	
	// ヘッダーにアクセスの表示
	$("#detail_spot_name").empty();
	$("#detail_spot_name").append(contentString);
	
	/*
	// バス停情報の表示
	$("#bus_info").empty();
	$("#bus_info").append(spot_data[id].bus_info);
	*/
}


// マップ作成
function createDetailMap(divId){
	
	var mapOptions = {
		zoom: 16,
		center: new google.maps.LatLng(35.181448, 136.915933),
		mapTypeControl: false,
		streetViewControl: false,
		panControl: false,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	map = new google.maps.Map(document.getElementById(divId),mapOptions);
	// HTML5 geolocation 機能で現在地を取得
	if(navigator.geolocation) {
		navigator.geolocation.getCurrentPosition(function(position) {

			
			// ユーザの現在位置にマーカーを設置
			user_lat = position.coords.latitude;
			user_lng = position.coords.longitude;
			var user_pos = new google.maps.LatLng(user_lat ,user_lng);
			var userIcon = new google.maps.MarkerImage('http://app.linkdata.org/asset/407e87a1.png');
			userIcon.scaledSize = new google.maps.Size(55, 55);
			
			var user_mk = new google.maps.Marker({
				 position: user_pos,
				 map: map,
				 icon: userIcon,
				 title: '現在位置'
			});
/*
			var user_iw = new google.maps.InfoWindow({
				content: '現在位置'

			});
			
			google.maps.event.addListener(user_mk, 'click', function() {
				user_iw.open(map,user_mk);
			});
*/
		}, function() {
			//mapNoGeolocation(true);
		});
	} else {
		// ブラウザがGeolocationをサポートしていない
		//mapNoGeolocation(false);
	}
	
}

// スポットマーカーの設置
function createDetailMarker(id,content,latlng,icon,map){
	// マーカーの作成
	var marker = new google.maps.Marker({
		id: id,
		position: latlng,
		map: map,
		icon: icon
	});
/*	
	// infoWindowの作成
	var infoWindow = new google.maps.InfoWindow();
	google.maps.event.addListener(marker, 'click', function() {
		if (currentWindow) {
			currentWindow.close();
		}
		infoWindow.setContent(content);
		infoWindow.open(map,marker);
		currentWindow = infoWindow;
	});
	// infoWindowを開く
	if (currentWindow) {
		currentWindow.close();
	}
	infoWindow.setContent(content);
	infoWindow.open(map,marker);
	currentWindow = infoWindow;
*/
} 

//######################################################################################################################################
//  データ読み込み関連
//######################################################################################################################################

//--------------------------------------------
// データの読み込み
//--------------------------------------------

// LinkDataからデータの読み込み
function loadData() {
	
	// LinkDataからのデータの取得
	var workValue = 'rdf1s1870i';
	
	//---------------------------------------------------
	// スポットデータの読み込み
	//---------------------------------------------------
	var fileValue = 'bunkanomichi_event_spot_list';
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = {}
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#spot_name'){
					tmp_data['name'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#yomi_name'){
					tmp_data['yomi_name'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#lat'){
					tmp_data['lat'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#lng'){
					tmp_data['lng'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#subway'){
					tmp_data['subway'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#bus'){
					tmp_data['bus'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#tel'){
					tmp_data['tel'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#stamp'){
					tmp_data['stamp'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#fee'){
					tmp_data['fee'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#comment'){
					tmp_data['comment'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#img'){
					tmp_data['img'] = objValue;
				} 
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	spot_data = tmp_dataArray; // スポットデータを代入
	
	//---------------------------------------------------
	// イベントジャンルデータの読み込み
	//---------------------------------------------------
	var fileValue = 'bunkanomichi_event_genre';
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = {}
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#genre_name'){
					tmp_data['genre'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#event_total'){
					tmp_data['total'] = objValue;
				}
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	genre_data = tmp_dataArray; // イベントジャンルデータを代入
	
		
	//---------------------------------------------------
	// イベントタイムテーブルの読み込み
	//---------------------------------------------------
	var fileValue = 'bunkanomichi_event_timetable';
	tmp_dataArray = new Array();
	
		$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = {}
		s_time = new Date();
		e_time = new Date();
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#event_id'){
					tmp_data['event_id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#date'){
					var array = objValue.split("-");
					tmp_data['date'] = array[1] +'/'+ array[2];
					tmp_data['date2']= array[1] + array[2];
					s_time.setFullYear(array[0]);
					s_time.setMonth(array[1]-1);
					s_time.setDate(array[2]);
					e_time.setFullYear(array[0]);
					e_time.setMonth(array[1]-1);
					e_time.setDate(array[2]);
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#start'){
					var array = objValue.split(":");
					tmp_data['start'] = array[0] +':'+ array[1];
					s_time.setHours(array[0]);
					s_time.setMinutes(array[1]);
					tmp_data['s_time'] = s_time;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#end'){
					var array = objValue.split(":");
					tmp_data['end'] = array[0] +':'+ array[1];
					e_time.setHours(array[0]);
					e_time.setMinutes(array[1]);
					tmp_data['e_time'] = e_time;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#comment'){
					tmp_data['text'] = objValue;
				}
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	eventtime_data = tmp_dataArray; // イベントデータを代入
	
	//---------------------------------------------------
	// イベントリストデータの読み込み
	//---------------------------------------------------
	var fileValue = 'bunkanomichi_event_list';
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		
		var tmp_data = {}
		
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#title'){
					tmp_data['title'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#subtitle'){
					tmp_data['text'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#place'){
					tmp_data['place'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#spot'){
					tmp_data['spot_id'] = objValue;
					for (var i in spot_data) {
						if (objValue == spot_data[i].id){
							tmp_data['spot'] = spot_data[i].name;
						}
					}
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#genre'){
					tmp_data['genre_id'] = objValue;
					for (var i in genre_data) {
						if (objValue == genre_data[i].id){
							tmp_data['genre'] = genre_data[i].genre;
						}
					}
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#info'){
					tmp_data['info'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#limit'){
					tmp_data['limit'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#fee'){
					tmp_data['fee'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#presenter'){
					tmp_data['presenter'] = objValue;
				}
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	eventlist_data = tmp_dataArray; // イベントデータを代入
}
