/*
?subject=で指定されたポイントの緯度経度をJSONデータから取得し、その座標でコンビニまっぷのサイトを開きます。
*/

window.onload = function() {
//	parent.location.href = "http://cvs-map.jp/map?ll=35.5084037%2C139.6825397";
	var keyword = getParameterFromURL("subject"); // obtain keyword from the URL "?subject="
	var list = ""; // list to be displayed
	var redirect = false;
	// Work loop
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		// File loop
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			// Subject loop
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				if ( decodeURIComponent(subjValue) == keyword ) {
					var longitude = null;
					var latitude = null;
					$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
						var prop = tripleValue.property;
						var obj = tripleValue.object;
						if ( prop == "http://www.w3.org/2003/01/geo/wgs84_pos#long" ) longitude = obj;// longitude found
						if ( prop == "http://www.w3.org/2003/01/geo/wgs84_pos#lat" ) latitude = obj;// latitude found
					});
					if ( longitude != null && latitude != null ){
						parent.location.href = "http://cvs-map.jp/map?ll=" + latitude + "%2C" + longitude;
						redirect = true;
					}
				}
			});
		});
	});
	if ( redirect == false )
		$("#result").append( "このアプリを使用するにはこちらのページからアクセスしてください。<br><a href=\"http://linkdata.org/view/rdf1s2439i\" target=\"_top\">てくてく旧東海道</a>" );

};

// Get a parameter value in URL (e.g. ?paramString=value )
function getParameterFromURL( paramString )
{			
	var value = "";
	var topWindow = top.window.location.search;
	if( topWindow ){
		var q = decodeURIComponent(topWindow.substring(1,topWindow.length)).split("&");
		for ( var i = 0; i < q.length; i++ ){
			var r = q[i].split("=");
			if ( r[0] ==  paramString )
				value = r[1];
		}
	}
 	return value;
}
