var all_data; 
var markFLG = 0;
var currentInfoWindow = null;	//最後に開いた情報ウィンドウを記憶
var currentMarker = null;	//最後に開いたマカーを記憶

function initialize(){
	
	// １．データをLinkDataから取得
	all_data = new Array();
	work_data = new Array();
	$.each(LinkData.getWorks(), function(workKey, workValue) {
//		$("#result").append("<h3>workValue: " + workValue + "</h3>");
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
//			$("#result").append("<h3>fileValue: " + fileValue + "</h3>");
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				
//				$("#result").append("<h3>subjValue: " + subjValue + "</h3>");
				
				var tmp_data = {}
				tmp_data["id"] = subjValue;
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					
//					$("#result").append("<h3>propValue: " + propValue + "</h3>");
					
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						
//						$("#result").append("<h3>objValue: " + objValue + "</h3>");
						
						if(propValue == "http://purl.org/dc/elements/1.1/description"){
							tmp_data["description"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#lat"){
							tmp_data["lat"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#long"){
							tmp_data["longitude"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s2662i#%E6%B4%8B%E5%BC%8F"){
							tmp_data["yousiki"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s2662i#%E3%83%A9%E3%83%B3%E3%82%AF"){
							tmp_data["rank"] = objValue;
						}else if(propValue == "http://www.w3.org/2000/01/rdf-schema#label"){
							tmp_data["label"] = objValue;
						}
					});
				});
				work_data.push(tmp_data);
			});
		});
	});
	//全データ
	all_data = work_data;
	//for (var i in all_data){ 
	//$("#result").append("<h3>all_data: " + all_data[i].description + "</h3>");
	//}
	
	// ２．取得した情報を地図に表示
	
    // 中心の初期値:「長野県庁」
    var latlng = new google.maps.LatLng(36.649231, 138.182394);
	
    var myOptions = {
        zoom: 15,
    	center: latlng,
        mapTypeId: google.maps.MapTypeId.ROADMAP
    };
	// htmlに地図描画
    var map = new google.maps.Map(document.getElementById("result"), myOptions);
	
	// ウィンドウに表示するデータを作成
	var data = new Array();

	for (var i in all_data){ 
        var value = all_data[i].label;  
        data.push({position: new google.maps.LatLng(all_data[i].lat, all_data[i].longitude), content: '<h4>' + all_data[i].label +'</h4>' + '<br>' + '洋式：' + all_data[i].yousiki + '<br><small>' + '設備：' + all_data[i].description +'</small>',rank:all_data[i].rank});
	};     

    // 地図上にウィンドウで表示
    for (i = 0; i < data.length; i++) {
		//マーカーの配置
         var marker = new google.maps.Marker({
            position: data[i].position,
			animation: google.maps.Animation.DROP,
			 //ピンにランクを表示
 			//icon: "http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=" + data[i].rank + "|66FFFF|000000",
 			icon: "http://chart.apis.google.com/chart?chst=d_map_xpin_icon&chld=pin|glyphish_walk|99FFFF",
			 //ピンを吹き出し表示
			 //icon:"https://chart.googleapis.com/chart?chst=d_bubble_icon_text_small&chld=wc-male|bb|" + data[i].rank + "|FFFFFF|000000",
            map: map
        });
		//情報ウインドウの設定
        attachMessage(marker, data[i].content);
    };

};

// マーカーをクリックするとウィンドウを表示する処理
function attachMessage(marker, msg) {
	google.maps.event.addListener(marker, 'click', function(event) {
    	infowindow = new google.maps.InfoWindow({
			content: msg
        });
		
		//前回表示分のウインドウがあったら消して止める
		if(markFLG == 1){
			currentInfoWindow.close();
			currentMarker.setAnimation(null);
			markFLG = 0;
		}
		
		infowindow.open(marker.getMap(), marker);
		marker.setAnimation(google.maps.Animation.BOUNCE);
		markFLG = 1;
		currentInfoWindow = infowindow;
		currentMarker　= marker;
		
    });
	
};

window.onload = function() {
    $(function(){
		//$("#result").append("<h3>log: " + "start" + "</h3>");
    	initialize();     
		//$("#result").append("<h3>log: " + "end" + "</h3>");
    });	
};
