HighChart2 = function(containerId, options) {
	new Application.highChart(containerId, options);
};

if (Application === "undefined" || !Application) {
	var Application = {};
}

Application.highChart = function() {
	this._init.apply(this, arguments);
};

Application.highChart.prototype = {
	
	_containerId : null,
	_options : null,
	_workId : null,
	_fileName : null,
	_highChartContainerId : null,
	_appProperty : null,
	
	_default : {
		filterNamespace : "http://linkdata.org/",
		subjectUriPhrase : "http://atted.jp/data/locus/",
		subjectPPDBUriPhrase : "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene=",
		selectSubjectClass : "selectSubject",
		drawArea : "drawArea",
		loadingImageContainer : "loadingImageContainer",
		acceptPropLabelPrefix : "label:",
		loadingImageUrl : "http://app.linkdata.org/asset/67556085.gif"
	},
	
	_init : function(containerId, options) {
		this._containerId = containerId;
		this._options = $.extend({}, this._default, options);
		this._workId = this._options.workId;
		this._fileName = this._options.fileName;
		var date = new Date();
		this._highChartContainerId = "high_chart_" + date.getTime();
		this._initAppProperty(this._options);
		this._initView();
		//this._initSelect();
	},
	
	_initAppProperty : function(opts) {
		var obj = {
			workId : opts.workId,
			fileName : opts.fileName
		};
		this._appProperty = new Application.motifProperty(obj);
	},
	
	_initView : function() {
		var self = this;
		var initView = function(subjectList) {
			var sb = [];
			sb[sb.length] = "<div class='row'>";
			sb[sb.length] = "<div class='label left'>Select Subject</div>";
			sb[sb.length] = "<div class='left'>";
			sb[sb.length] = "<select class='" + self._default.selectSubjectClass + "'>";
			sb[sb.length] = "<option value='" + -1 + "'>-- Select Subject --</option>";
			$.each(subjectList, function(subKey, subValue) {
				var label = self._getLabel(subValue);
				sb[sb.length] = "<option value='" + subValue + "'>" + label + "</option>";
			});
			sb[sb.length] = "</select>";
			sb[sb.length] = "</div>";
			sb[sb.length] = "</div>";
			sb[sb.length] = "<div id='" + self._highChartContainerId + "'></div>";
			sb[sb.length] = "<div class='" + self._options.loadingImageContainer + " hidden' align='center'>";
			sb[sb.length] = "<img src='" + self._options.loadingImageUrl + "'/>";
			sb[sb.length] = "</div>";
			//$("#" + self._containerId).append(sb.join(""));
			$("#" + self._containerId).html(sb.join(""));
			self._initSelect();
		}
		LinkData.getSubjects(self._workId, self._fileName, initView);
	},
	
	_initSelect : function() {
		var self = this;
		var timer = new Application.timer();
		var initSelect = function() {
			$select = $("#" + self._containerId + " ." + self._default.selectSubjectClass);
			if ($select.length != 0) {
				$select.change(function() {
					$("#" + self._containerId + " ." + self._options.loadingImageContainer).show();
					var subject = $("option:selected", this).val();
					self._drawHighChart(subject);
					//var dataArray = self._getDataArray(self._workId, self._fileName, subject);
					//var xCategory = self._getXCategory(self._workId, self._fileName, subject);
					//self._drawChart(self._highChartContainerId, dataArray, xCategory);
				});
			} else {
				timer.call(initSelect);
			}
		}
		initSelect();
	},
	
	_ignore : function(label) {
		var self = this;
		if (label.indexOf(self._default.acceptPropLabelPrefix) > -1) {
			return false;
		}
		return true;
	},
	
	_getDisplayLabel : function(value) {
		var self = this;
		var propLabel = value;
		var arr = value.split(self._default.acceptPropLabelPrefix);
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	_drawHighChart : function(subject) {
		var self = this;
		var getDataArray = function(tripleList) {
			var dataArray = [];
			var dataObject = {};
			var array = [];
			var duplicateProperty = [];
			$.each (tripleList, function(tKey, tValue) {
				var property = tValue.property;
				if (property.indexOf(self._options.filterNamespace) == -1) {
					return;
				}
				if ($.inArray(property, duplicateProperty) > -1) {
					return;
				}
				var label = self._getLabelAfterHash(property);
				if (!self._ignore(label)) {
					array.push(parseFloat(tValue.object));
					duplicateProperty.push(property);
				}
			});
			dataObject.name = self._getLabel(subject);
			dataObject.data = array;
			dataArray.push(dataObject);
			self._getXCategory(tripleList, dataArray);
		}
		LinkData.getTriplesBySubject(self._workId, self._fileName, subject, getDataArray);
	},
	
	_getXCategory : function(tripleList, dataArray) {
		var self = this;
		var array = [];
		var duplicateProperty = [];
		$.each (tripleList, function(tKey, tValue) {
			var property = tValue.property;
			if (property.indexOf(self._options.filterNamespace) == -1) {
				return;
			}
			if ($.inArray(property, duplicateProperty) > -1) {
				return;
			}
			var label = self._getLabelAfterHash(property);
			if (!self._ignore(label)) {
				array.push(self._getDisplayLabel(label));
				duplicateProperty.push(property);
			}
		});
		self._drawChart(self._highChartContainerId, dataArray, array);
		$("#" + self._containerId + " ." + self._options.loadingImageContainer).hide();
	},
	
	_drawChart : function(containerId, dataArray, xCategory) {
		var self = this;
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: containerId,
				type: 'line',
				marginRight: 130,
				marginBottom: 125
			},
			title: {
				text: self._fileName
			},
			xAxis: {
				categories: xCategory,
				labels : {
					rotation: 315
				}
			},
			tooltip: {
				formatter: function() {
					return '<b>'+ this.series.name + '</b><br/>' + this.x + ' [' + this.y + ']';
				}
			},
			legend: {
				layout: 'vertical',
				align: 'right',
				verticalAlign: 'top',
				x: -10,
				y: 100,
				borderWidth: 0
			},
			series: dataArray
 		});
	},
	
	/*
	_getLabel : function(value) {
		var self = this;
		if (value.indexOf(self._default.subjectUriPhrase) > -1) {
			var propLabel = value;
			var arr = value.split(self._default.subjectUriPhrase);
			if (arr.length > 1) {
				propLabel = decodeURIComponent(arr[1]);
			}
			return propLabel;
		} else if (value.indexOf(self._default.subjectPPDBUriPhrase) > -1) {
			var propLabel = value;
			var arr = value.split(self._default.subjectPPDBUriPhrase);
			if (arr.length > 1) {
				propLabel = decodeURIComponent(arr[1]);
			}
			return propLabel;
		} else if (value.indexOf("#") > -1) {
			return self._getLabelAfterHash(value);
		}
		return value;
	},
*/
	_getLabel : function(value) {
		var self = this, label;
		if (value.indexOf("#") > -1) {
			label = self._getLabelAfterHash(value);
		} else {
			label = self._appProperty.getGeneBySubject(value);
		}
		if (!label) {
			label = value;
		}
		return label;
	},
	
	_getPropertyLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
			propLabel = this._appProperty.getPropertyNameByLabel(propLabel);
		}
		return propLabel;
	},
	
	_getLabelAfterHash : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	}
	
};

Application.motifProperty = function() {
	this._init.apply(this, arguments);
};

Application.motifProperty.prototype = {

	_options : null,
	_propMap : null,
	_nameMap : null,
	_optionArray : null,
	
	_default : {
		acceptPropLabelPrefix : "label:",
		subjectATTEDUriPhrase : "http://atted.jp/data/locus/",
		subjectPPDBUriPhrase : "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene="
	},
	
	_init : function(options) {
		this._options = $.extend({}, this._default, options);
		this._propMap = [];
		this._nameMap = [];
		this._initPropMap(this._options);
	},
	
	_initPropMap : function(opts) {
		var self = this, workId = opts.workId, fileName = opts.fileName;
		var method = function(properties) {
			self._fillPropMap(self, properties);
			self._initOptionArray(properties);
		}
		LinkData.getProperties(workId, fileName, method);
	},
	
	_fillPropMap : function(self, properties) {
		$.each(properties, function(key, value) {
			var label = self._getLabel(value);
			if (!self._propMap[label]) {
				self._propMap[label] = value;
			}
		});
	},
	
	_initOptionArray : function(propertyList) {
		var self = this, list = new Object();
		var workId = self._options.workId, fileName = self._options.fileName;
		self._optionArray = [];
		$.each(propertyList, function(key, value) {
			var propLabel = self._getLabel(value);
			if (!self._ignore(propLabel)) {
				var obj = {};
				obj.key = propLabel;
				obj.value = self._getDisplayLabel(propLabel);
				self._optionArray.push(obj);
			}
		});
	},
	
	_ignore : function(label) {
		var self = this;
		if (label.indexOf(self._default.acceptPropLabelPrefix) > -1) {
			return false;
		}
		return true;
	},
	
	_getDisplayLabel : function(value) {
		var self = this;
		var propLabel = value;
		var arr = value.split(self._default.acceptPropLabelPrefix);
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	_getLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},

	getOptionArray : function() {
		return this._optionArray;
	},
	
	getPropertyByLabel : function(label) {
		return this._propMap[label];
	},
	
	getGeneBySubject : function(subject) {
		var self = this, htmlExt = ".html", geneLabel;
		if (subject.indexOf(self._default.subjectATTEDUriPhrase) > -1) {
			geneLabel = subject.replace(self._default.subjectATTEDUriPhrase, "");
		} else if (subject.indexOf(self._default.subjectPPDBUriPhrase) > -1) {
			geneLabel = subject.replace(self._default.subjectPPDBUriPhrase, "");
		}
		if (geneLabel && geneLabel.indexOf(htmlExt) > -1) {
			geneLabel = geneLabel.replace(htmlExt, "");
		}
		return geneLabel;
	}
	
};

Application.timer = function() {
	this._init.apply(this, arguments);
};

Application.timer.prototype = {
	
	_delay : null,
	_retry : null,
	_maxRetry : null,
	
	_init : function() {
		this._delay = 1000;
		this._retry = 0;
		this._maxRetry = 100;
	},
	
	call : function(func) {
		if (this._retry < this._maxRetry) {
			setTimeout(func, this._delay);
		}
		this._retry++;
	}
};

$(document).ready(function(){
	var fillDatabase = function(resultList) {
		$(".highChartDatabase").append("<option value='-1' selected='selected'>-- Select Database --</option>");
		$.each(resultList, function(workId, fileList) {
			$.each(fileList, function(fileKey, fileName) {
				$(".highChartDatabase").append("<option value='" + workId + "|" + fileName + "'>" + fileName + "</option>");
			});
		});
		$(".highChartDatabase").change(function() {
			var dbKey = $("option:selected", $(this)).val();
			if (dbKey == -1) {
				$("#container").html("");
				return;
			}
			var array = dbKey.split("|");
			var containerId = "container";
			var options = {
				workId : array[0],
				fileName : array[1],
				baseSequence : "GAAAAAAGACGTTCCAACCACGTCTTCAAAGCAAGTGATTGGATTAAGGTTCTTCCACACGGTAAGGGATGGCACTAACACCTACCATCCTTCGCAAGACCCTTCCTCTATATAAGGAAGTTCATTTCATTTGGAGAGGACCTCGAC"
			};
			new Application.highChart(containerId, options);
		});
	}
	LinkData.getFilesByTag(null, "database", fillDatabase);
});
